#ifdef PRECOMPILEDHEADERS
	#include "Tactical All.h"
#else
	#include "items.h"
	#include "Action Items.h"
	#include "weapons.h"
	#include "Interface Cursors.h"
	#include "Soldier Control.h"
	#include "overhead.h"
	#include "Handle UI.h"
	#include "Animation Control.h"
	#include "points.h"
	#include "Sound Control.h"
	#include "Sys globals.h"
	#include "Isometric Utils.h"
	#include "Animation Data.h"
	#include "worldman.h"
	#include "Random.h"
	#include "Campaign.h"
	#include "interface.h"
	#include "interface panels.h"
	#include "explosion control.h"
	#include "Keys.h"

	#include "wcheck.h"
	#include "soldier profile.h"
	#include "SkillCheck.h"
	#include "los.h"
	#include "message.h"
	#include "text.h"

	#include "fov.h"
	#include "MessageBoxScreen.h"

	#include "PathAIDebug.h"
	#include "Interface Control.h"
	#include "ShopKeeper Interface.h"
	#include "Cursors.h"
#endif

#include <Tchar.h>
#include <Windowsx.h>

#define ANY_MAGSIZE 255

//<SB>
#define ITEMTYPE_TAG		_T("ITEMTYPE")
//</SB>

void RemoveObjs( OBJECTTYPE * pObj, UINT8 ubNumberToRemove );
void SetNewItem( SOLDIERTYPE *pSoldier, UINT8 ubInvPos, BOOLEAN fNewItem );

extern	SOLDIERTYPE *gpItemDescSoldier;

// weight units are 100g each

////////////////////////////////////////////////////////////////////////////
//ATE: When adding new items, make sure to update text.c with text description
///////////////////////////////////////////////////////////////////////////
INVTYPE Item[MAXITEMS];

typedef struct
{
	UINT16	usItem;
	UINT32	uiItemClass;
	INT8		bAttachmentSkillCheck;
	INT8		bAttachmentSkillCheckMod;
} AttachmentInfoStruct;

#define ATTACHMENTINFO_TAG		_T("ATTACHMENTINFO")
#define MAX_ATTACHMENTINFO		256

// NB hack:  if an item appears in this array with an item class of IC_MISC,
// it is a slot used for noting the skill check required for a merge or multi-item attachment
AttachmentInfoStruct AttachmentInfo[MAX_ATTACHMENTINFO];

#define ATTACH_TAG		_T("ATTACH")
#define MAX_ATTACH		1024

UINT16 Attachment[MAX_ATTACH][2];

#define LAUNCHABLE_TAG		_T("LAUNCHABLE")
#define MAX_LAUNCHABLE		256

UINT16 Launchable[MAX_LAUNCHABLE][2];

#define FACECOMBO_TAG		_T("FACECOMBO")
#define MAX_FACECOMBO		256

UINT16 CompatibleFaceItems[MAX_FACECOMBO][2];

typedef enum
{
	DESTRUCTION,
	COMBINE_POINTS,
	TREAT_ARMOUR,
	EXPLOSIVE,
	EASY_MERGE,
	ELECTRONIC_MERGE,
} MergeType;

#define CHECK_ID(item)	if(!_tcscmp(_T(#item),tsClass)) return item;

UINT16 GetMergeMethodByName(LPCTSTR tsClass)
{
	CHECK_ID(DESTRUCTION);
	CHECK_ID(COMBINE_POINTS);
	CHECK_ID(TREAT_ARMOUR);
	CHECK_ID(EXPLOSIVE);
	CHECK_ID(EASY_MERGE);
	CHECK_ID(ELECTRONIC_MERGE);
	return DESTRUCTION;
}

#define MERGE_TAG		_T("MERGE")
#define MAX_MERGE		512

UINT16 Merge[MAX_MERGE][4];

typedef struct
{
	UINT16	usItem;
	UINT16	usAttachment[2];
	UINT16	usResult;
} ComboMergeInfoStruct;

#define COMBO_TAG		_T("COMBO")
#define MAX_COMBO		512

ComboMergeInfoStruct AttachmentComboMerge[MAX_COMBO];

UINT16 ReplacementGuns[][2] =
{
	{ 0,						0						}
};

UINT16 ReplacementAmmo[][2] =
{
	{ 0,								0							 }
};

//</SB>

#define CHECK_ID(item)	if(!_tcscmp(_T(#item),tsClass)) return item;

int GetCursorIdByName(LPCTSTR tsClass)
{
	CHECK_ID(INVALIDCURS);
	CHECK_ID(QUESTCURS);
	CHECK_ID(PUNCHCURS);
	CHECK_ID(TARGETCURS);
	CHECK_ID(KNIFECURS);
	CHECK_ID(AIDCURS);
	CHECK_ID(TOSSCURS);
	CHECK_ID(MINECURS);
	CHECK_ID(LPICKCURS);
	CHECK_ID(MDETECTCURS);
	CHECK_ID(CROWBARCURS);
	CHECK_ID(SURVCAMCURS);
	CHECK_ID(CAMERACURS);
	CHECK_ID(KEYCURS);
	CHECK_ID(SAWCURS);
	CHECK_ID(WIRECUTCURS);
	CHECK_ID(REMOTECURS);
	CHECK_ID(BOMBCURS); // ( only calculated, not set item table )
	CHECK_ID(REPAIRCURS);
	CHECK_ID(TRAJECTORYCURS);
	CHECK_ID(JARCURS);
	CHECK_ID(TINCANCURS);
	CHECK_ID(REFUELCURS);
	return INVALIDCURS;
}

int GetItemClassIdByName(LPCTSTR tsClass)
{
	CHECK_ID(IC_NONE);
	CHECK_ID(IC_GUN);
	CHECK_ID(IC_BLADE);
	CHECK_ID(IC_THROWING_KNIFE);

	CHECK_ID(IC_LAUNCHER);
	CHECK_ID(IC_TENTACLES);

	CHECK_ID(IC_THROWN);
	CHECK_ID(IC_PUNCH);

	CHECK_ID(IC_GRENADE);
	CHECK_ID(IC_BOMB);
	CHECK_ID(IC_AMMO);
	CHECK_ID(IC_ARMOUR);

	CHECK_ID(IC_MEDKIT);
	CHECK_ID(IC_KIT);
	CHECK_ID(IC_APPLIABLE);
	CHECK_ID(IC_FACE);

	CHECK_ID(IC_KEY);

	CHECK_ID(IC_MISC);
	CHECK_ID(IC_MONEY);
	return IC_NONE;
}


int GetItemsIniSettings(TCHAR * tsIniPath, HWND hConsole)
{
	int i;
	TCHAR tsFullCachePath[MAX_PATH];
	TCHAR tsBuffer[64];
	TCHAR tsSectionName[32] = ITEMTYPE_TAG;
	//<0.98 b16>
	TCHAR tsFullIniPath[MAX_PATH];
	HANDLE hCache, hIni;
	DWORD dwBytesRead;
	FILETIME iniModificationTime = {0}, cacheTime = {1};
	//</0.98 b16>

	_tcscpy(tsFullIniPath,tsIniPath);
	_tcscat(tsFullIniPath,_T("\\items.ini"));
	//<0.98 b16>
	hIni = CreateFile(tsFullIniPath,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,0,NULL);
	if( hIni != INVALID_HANDLE_VALUE )
	{
		GetFileTime( hIni, NULL, NULL, &iniModificationTime );
		CloseHandle( hIni );
	}
	_tcscpy(tsFullCachePath,tsIniPath);
	_tcscat(tsFullCachePath,_T("\\DATA\\items.cache"));
	hCache = CreateFile(tsFullCachePath,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,0,NULL);
	if( hCache != INVALID_HANDLE_VALUE )
		ReadFile( hCache, &cacheTime, sizeof(FILETIME), &dwBytesRead, NULL);
	if( !CompareFileTime( &iniModificationTime, &cacheTime ) ) // if cache is valid
	{
		ReadFile( hCache, Item, sizeof(INVTYPE)*MAXITEMS, &dwBytesRead, NULL);
		CloseHandle( hCache );
		Edit_ReplaceSel(hConsole,"\r\nitem_types_loaded_from_cache");
		return 1;
	}
	//</0.98 b16>

	// Get item types
	Edit_ReplaceSel(hConsole,"\r\nloading_item_types");
	for( i=0; i<MAXITEMS; i++ )
	{
		_itot( i, tsSectionName+_tcslen(ITEMTYPE_TAG), 10);
		GetPrivateProfileString(tsSectionName, _T("ItemClass"), _T("IC_NONE"), tsBuffer, 64, tsFullIniPath);
		if( (Item[i].usItemClass = GetItemClassIdByName(tsBuffer))==IC_NONE )
				continue;
		Item[i].ubClassIndex = GetPrivateProfileInt(tsSectionName,_T("ClassIndex"),0, tsFullIniPath);
		GetPrivateProfileString(tsSectionName, _T("Cursor"), _T("INVALIDCURS"), tsBuffer, 64, tsFullIniPath);
		Item[i].ubCursor = GetCursorIdByName(tsBuffer);
		Item[i].ubGraphicType = GetPrivateProfileInt(tsSectionName,_T("GraphicType"),0, tsFullIniPath);
		Item[i].ubGraphicNum = GetPrivateProfileInt(tsSectionName,_T("GraphicNum"),0, tsFullIniPath);
		Item[i].ubWeight = GetPrivateProfileInt(tsSectionName,_T("Weight"),0, tsFullIniPath);
		Item[i].ubPerPocket = GetPrivateProfileInt(tsSectionName,_T("SizePerPocket"),0, tsFullIniPath);
		Item[i].usPrice = GetPrivateProfileInt(tsSectionName,_T("Price"),0, tsFullIniPath);
		Item[i].ubCoolness = GetPrivateProfileInt(tsSectionName,_T("Coolness"),0, tsFullIniPath);
		Item[i].bReliability = GetPrivateProfileInt(tsSectionName,_T("Reliability"),0, tsFullIniPath);
		Item[i].bRepairEase = GetPrivateProfileInt(tsSectionName,_T("RepairEase"),0, tsFullIniPath);
		Item[i].fFlags = 0;
		Item[i].fFlags |= GetPrivateProfileInt(tsSectionName,_T("Damageable"),0, tsFullIniPath)?ITEM_DAMAGEABLE:0;
		Item[i].fFlags |= GetPrivateProfileInt(tsSectionName,_T("Repairable"),0, tsFullIniPath)?ITEM_REPAIRABLE:0;
		Item[i].fFlags |= GetPrivateProfileInt(tsSectionName,_T("WaterDamages"),0, tsFullIniPath)?ITEM_WATER_DAMAGES:0;
		Item[i].fFlags |= GetPrivateProfileInt(tsSectionName,_T("Metal"),0, tsFullIniPath)?ITEM_METAL:0;
		Item[i].fFlags |= GetPrivateProfileInt(tsSectionName,_T("Sinks"),0, tsFullIniPath)?ITEM_SINKS:0;
		Item[i].fFlags |= GetPrivateProfileInt(tsSectionName,_T("ShowStatus"),0, tsFullIniPath)?ITEM_SHOW_STATUS:0;
		Item[i].fFlags |= GetPrivateProfileInt(tsSectionName,_T("HiddenAddon"),0, tsFullIniPath)?ITEM_HIDDEN_ADDON:0;
		Item[i].fFlags |= GetPrivateProfileInt(tsSectionName,_T("TwoHanded"),0, tsFullIniPath)?ITEM_TWO_HANDED:0;
		Item[i].fFlags |= GetPrivateProfileInt(tsSectionName,_T("NotBuyable"),0, tsFullIniPath)?ITEM_NOT_BUYABLE:0;
		Item[i].fFlags |= GetPrivateProfileInt(tsSectionName,_T("Attachment"),0, tsFullIniPath)?ITEM_ATTACHMENT:0;
		Item[i].fFlags |= GetPrivateProfileInt(tsSectionName,_T("BigGunList"),0, tsFullIniPath)?ITEM_BIGGUNLIST:0;
		Item[i].fFlags |= GetPrivateProfileInt(tsSectionName,_T("NotEditor"),0, tsFullIniPath)?ITEM_NOT_EDITOR:0;
		Item[i].fFlags |= GetPrivateProfileInt(tsSectionName,_T("DefaultUndroppable"),0, tsFullIniPath)?ITEM_DEFAULT_UNDROPPABLE:0;
		Item[i].fFlags |= GetPrivateProfileInt(tsSectionName,_T("Unaerodynamic"),0, tsFullIniPath)?ITEM_UNAERODYNAMIC:0;
		Item[i].fFlags |= GetPrivateProfileInt(tsSectionName,_T("Electronic"),0, tsFullIniPath)?ITEM_ELECTRONIC:0;
//		Item[i].fFlags |= GetPrivateProfileInt(tsSectionName,_T("Inseparable"),0, tsFullIniPath)?ITEM_INSEPARABLE:0;
		Item[i].fFlags |= GetPrivateProfileInt(tsSectionName,_T("VeryBig"),0, tsFullIniPath)?ITEM_IS_VERY_BIG:0;
//0.97b19
		Item[i].usConvertsToItem = GetPrivateProfileInt(tsSectionName,_T("convert_to"),0, tsFullIniPath);
//0.97.22
		Item[i].ubConvertAP = GetPrivateProfileInt(tsSectionName,_T("convert_AP"),4, tsFullIniPath);

//SB: temp
//		WritePrivateProfileString(tsSectionName,_T("BobbyRayNewMax"), _itot(StoreInventory[i][BOBBY_RAY_NEW], tsBuffer, 10) , tsFullIniPath);
//		WritePrivateProfileString(tsSectionName,_T("BobbyRayUsedMax"), _itot(StoreInventory[i][BOBBY_RAY_USED], tsBuffer, 10) , tsFullIniPath);
//		WritePrivateProfileString(tsSectionName,_T("BobbyRayWeaponROF"), _itot(WeaponROF[i], tsBuffer, 10) , tsFullIniPath);
//
		Edit_ReplaceSel(hConsole,".");
	}
	Edit_ReplaceSel(hConsole,"done");
	//<0.98 b16>
	Edit_ReplaceSel(hConsole,"\r\ncaching_item_types-");
	if( hCache != INVALID_HANDLE_VALUE )
		CloseHandle( hCache );
	hCache = CreateFile(tsFullCachePath,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,0,NULL);
	WriteFile( hCache, &iniModificationTime, sizeof(FILETIME), &dwBytesRead, NULL);
	WriteFile( hCache, Item, sizeof(INVTYPE)*MAXITEMS, &dwBytesRead, NULL);
	CloseHandle( hCache );
	Edit_ReplaceSel(hConsole,"done");
	//</0.98 b16>
	return 1;
}


int GetSkillCheckIdByName(LPCTSTR tsClass)
{
	CHECK_ID(LOCKPICKING_CHECK);
	CHECK_ID(ELECTRONIC_LOCKPICKING_CHECK);
	CHECK_ID(ATTACHING_DETONATOR_CHECK);
	CHECK_ID(ATTACHING_REMOTE_DETONATOR_CHECK);

	CHECK_ID(PLANTING_BOMB_CHECK);
	CHECK_ID(PLANTING_REMOTE_BOMB_CHECK);

	CHECK_ID(OPEN_WITH_CROWBAR);
	CHECK_ID(SMASH_DOOR_CHECK);

	CHECK_ID(DISARM_TRAP_CHECK);
	CHECK_ID(UNJAM_GUN_CHECK);
	CHECK_ID(NOTICE_DART_CHECK);
	CHECK_ID(LIE_TO_QUEEN_CHECK);

	CHECK_ID(ATTACHING_SPECIAL_ITEM_CHECK);
	CHECK_ID(ATTACHING_SPECIAL_ELECTRONIC_ITEM_CHECK);
	CHECK_ID(DISARM_ELECTRONIC_TRAP_CHECK);
	return NO_CHECK;
}

int GetAttachsIniSettings(TCHAR * tsIniPath, HWND hConsole)
{
	int i;
	TCHAR tsFullIniPath[MAX_PATH];
	TCHAR tsBuffer[64];
	TCHAR tsSectionName[32];
	//<0.98 b16>
	TCHAR tsFullCachePath[MAX_PATH];
	HANDLE hCache, hIni;
	DWORD dwBytesRead;
	FILETIME iniModificationTime = {0}, cacheTime = {1};
	//</0.98 b16>

	_tcscpy(tsFullIniPath,tsIniPath);
	_tcscat(tsFullIniPath,_T("\\attach.ini"));
	//<0.98 b16>
	hIni = CreateFile(tsFullIniPath,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,0,NULL);
	if( hIni != INVALID_HANDLE_VALUE )
	{
		GetFileTime( hIni, NULL, NULL, &iniModificationTime );
		CloseHandle( hIni );
	}
	_tcscpy(tsFullCachePath,tsIniPath);
	_tcscat(tsFullCachePath,_T("\\DATA\\attach.cache"));
	hCache = CreateFile(tsFullCachePath,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,0,NULL);
	if( hCache != INVALID_HANDLE_VALUE )
		ReadFile( hCache, &cacheTime, sizeof(FILETIME), &dwBytesRead, NULL);
	if( !CompareFileTime( &iniModificationTime, &cacheTime ) ) // if cache is valid
	{
		ReadFile( hCache, AttachmentInfo, sizeof(AttachmentInfoStruct)*MAX_ATTACHMENTINFO, &dwBytesRead, NULL);
		ReadFile( hCache, Attachment, sizeof(UINT16)*2*MAX_ATTACH, &dwBytesRead, NULL);
		ReadFile( hCache, Launchable, sizeof(UINT16)*2*MAX_LAUNCHABLE, &dwBytesRead, NULL);
		ReadFile( hCache, CompatibleFaceItems, sizeof(UINT16)*2*MAX_FACECOMBO, &dwBytesRead, NULL);
		ReadFile( hCache, Merge, sizeof(UINT16)*4*MAX_MERGE, &dwBytesRead, NULL);
		ReadFile( hCache, AttachmentComboMerge, sizeof(ComboMergeInfoStruct)*MAX_COMBO, &dwBytesRead, NULL);
		CloseHandle( hCache );
		Edit_ReplaceSel(hConsole,"\r\nattach_info_loaded_from_cache");
		return 1;
	}
	//</0.98 b16>

	_tcscpy(tsSectionName,ATTACHMENTINFO_TAG);
	Edit_ReplaceSel(hConsole,"\r\nloading_AttachInfo");

	for( i=0; i<MAX_ATTACHMENTINFO; i++ )
	{
		_itot( i, tsSectionName+_tcslen(ATTACHMENTINFO_TAG), 10);
		AttachmentInfo[i].usItem = GetPrivateProfileInt(tsSectionName,_T("item"),0, tsFullIniPath);

		GetPrivateProfileString(tsSectionName, _T("itemclass"), _T("IC_NONE"), tsBuffer, 64, tsFullIniPath);
		AttachmentInfo[i].uiItemClass =  GetItemClassIdByName(tsBuffer);
		GetPrivateProfileString(tsSectionName, _T("skillcheck"), _T("NO_CHECK"), tsBuffer, 64, tsFullIniPath);
		AttachmentInfo[i].bAttachmentSkillCheck = GetSkillCheckIdByName(tsBuffer);
		AttachmentInfo[i].bAttachmentSkillCheckMod = GetPrivateProfileInt(tsSectionName,_T("skillcheckmod"),0, tsFullIniPath);
		Edit_ReplaceSel(hConsole,".");
	}
	Edit_ReplaceSel(hConsole,"done");

	Edit_ReplaceSel(hConsole,"\r\nloading_Attaches");
	_tcscpy(tsSectionName, ATTACH_TAG);
	for( i=0; i<MAX_ATTACH; i++ )
	{
		_itot( i, tsSectionName+_tcslen(ATTACH_TAG), 10);
		Attachment[i][0] = GetPrivateProfileInt(tsSectionName,_T("attach"),0, tsFullIniPath);
		Attachment[i][1] = GetPrivateProfileInt(tsSectionName,_T("to"),0, tsFullIniPath);
		Edit_ReplaceSel(hConsole,".");
	}
	Edit_ReplaceSel(hConsole,"done");

	Edit_ReplaceSel(hConsole,"\r\nloading_LaunchableAttaches");
	_tcscpy(tsSectionName, LAUNCHABLE_TAG);
 	for( i=0; i<MAX_LAUNCHABLE; i++ )
	{
		_itot( i, tsSectionName+_tcslen(LAUNCHABLE_TAG), 10);
		Launchable[i][0] = GetPrivateProfileInt(tsSectionName,_T("ammo"),0, tsFullIniPath);
		Launchable[i][1] = GetPrivateProfileInt(tsSectionName,_T("weapon"),0, tsFullIniPath);
		Edit_ReplaceSel(hConsole,".");
	}
	Edit_ReplaceSel(hConsole,"done");


	Edit_ReplaceSel(hConsole,"\r\nloading_FaceCombos");
	_tcscpy(tsSectionName, FACECOMBO_TAG);
 	for( i=0; i<MAX_FACECOMBO; i++ )
	{
		_itot( i, tsSectionName+_tcslen(FACECOMBO_TAG), 10);
		CompatibleFaceItems[i][0] = GetPrivateProfileInt(tsSectionName,_T("item1"),0, tsFullIniPath);
		CompatibleFaceItems[i][1] = GetPrivateProfileInt(tsSectionName,_T("item2"),0, tsFullIniPath);
		Edit_ReplaceSel(hConsole,".");
	}
	Edit_ReplaceSel(hConsole,"done");

	Edit_ReplaceSel(hConsole,"\r\nloading_Merge");
	_tcscpy(tsSectionName, MERGE_TAG);
 	for( i=0; i<MAX_MERGE; i++ )
	{
		_itot( i, tsSectionName+_tcslen(MERGE_TAG), 10);
		Merge[i][0] = GetPrivateProfileInt(tsSectionName,_T("attach"),0, tsFullIniPath);
		Merge[i][1] = GetPrivateProfileInt(tsSectionName,_T("item"),Merge[i][0], tsFullIniPath);
		Merge[i][2] = GetPrivateProfileInt(tsSectionName,_T("result"),Merge[i][0], tsFullIniPath);

		GetPrivateProfileString(tsSectionName, _T("type"), _T("DESTRUCTION"), tsBuffer, 64, tsFullIniPath);
		Merge[i][3] =  GetMergeMethodByName(tsBuffer);

		Edit_ReplaceSel(hConsole,".");
	}
	Edit_ReplaceSel(hConsole,"done");


	Edit_ReplaceSel(hConsole,"\r\nloading_FaceCombos");
	_tcscpy(tsSectionName, COMBO_TAG);
 	for( i=0; i<MAX_COMBO; i++ )
	{
		_itot( i, tsSectionName+_tcslen(COMBO_TAG), 10);
		AttachmentComboMerge[i].usItem			= GetPrivateProfileInt(tsSectionName,_T("item"),0, tsFullIniPath);
		AttachmentComboMerge[i].usAttachment[0] = GetPrivateProfileInt(tsSectionName,_T("attach1"),0, tsFullIniPath);
		AttachmentComboMerge[i].usAttachment[1] = GetPrivateProfileInt(tsSectionName,_T("attach2"),0, tsFullIniPath);
		AttachmentComboMerge[i].usResult		= GetPrivateProfileInt(tsSectionName,_T("result"),0, tsFullIniPath);
		Edit_ReplaceSel(hConsole,".");
	}
	Edit_ReplaceSel(hConsole,"done");

	//<0.98 b16>
	Edit_ReplaceSel(hConsole,"\r\ncaching_attach_info-");
	if( hCache != INVALID_HANDLE_VALUE )
		CloseHandle( hCache );
	hCache = CreateFile(tsFullCachePath,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,0,NULL);
	WriteFile( hCache, &iniModificationTime, sizeof(FILETIME), &dwBytesRead, NULL);
	WriteFile( hCache, AttachmentInfo, sizeof(AttachmentInfoStruct)*MAX_ATTACHMENTINFO, &dwBytesRead, NULL);
	WriteFile( hCache, Attachment, sizeof(UINT16)*2*MAX_ATTACH, &dwBytesRead, NULL);
	WriteFile( hCache, Launchable, sizeof(UINT16)*2*MAX_LAUNCHABLE, &dwBytesRead, NULL);
	WriteFile( hCache, CompatibleFaceItems, sizeof(UINT16)*2*MAX_FACECOMBO, &dwBytesRead, NULL);
	WriteFile( hCache, Merge, sizeof(UINT16)*4*MAX_MERGE, &dwBytesRead, NULL);
	WriteFile( hCache, AttachmentComboMerge, sizeof(ComboMergeInfoStruct)*MAX_COMBO, &dwBytesRead, NULL);
	CloseHandle( hCache );
	Edit_ReplaceSel(hConsole,"done");
	//</0.98 b16>
	return 1;
}


BOOLEAN IsWeaponItemEmpty(OBJECTTYPE * pGun)
{
//	if(Weapon[Item[pGun->usItem].ubClassIndex].ubChamber)
//		return !pGun->ubShotsLeft && !pGun->ubCartridgeInChamber;
//	else
		return !pGun->ubShotsLeft;
}

UINT8 DecreaseWeaponItemMag(OBJECTTYPE * pGun)
{
//	if(Weapon[Item[pGun->usItem].ubClassIndex].ubSelfloading)

//	if(Weapon[Item[pGun->usItem].ubClassIndex].ubChamber)
//		return !pGun->ubShotsLeft && !pGun->ubCartridgeInChamber;
//	else
//		return (pGun->ubShotsLeft--);
	return 0;
}

//</SB>

BOOLEAN ItemIsLegal( UINT16 usItemIndex )
{
	//if the user has selected the reduced gun list
//	if( !gGameOptions.fGunNut )
//	{
//		//if the item is a gun, or ammo
//		if( (Item[ usItemIndex ].usItemClass == IC_GUN) || (Item[ usItemIndex ].usItemClass == IC_AMMO ))
//		{
//			// and the item is only available with the extended guns
//			if( ExtendedGunListGun( usItemIndex ) )
//			{
//				return(FALSE);
//			}
//		}
//	}

	return(TRUE);
} 

// also used for ammo
BOOLEAN ExtendedGunListGun( UINT16 usGun )
{
//	return( (Item[ usGun ].fFlags & ITEM_BIGGUNLIST) != 0 );
	return TRUE;
} 

UINT16 StandardGunListReplacement( UINT16 usGun )
{
	UINT8 ubLoop;

	if ( ExtendedGunListGun( usGun ) )
	{
		ubLoop = 0;
		while ( ReplacementGuns[ ubLoop ][ 0 ] != 0 )
		{
			if ( ReplacementGuns[ ubLoop ][ 0 ] == usGun )
			{
				return( ReplacementGuns[ ubLoop ][ 1 ] );
			}
			ubLoop++;
		}
		// ERROR!
		AssertMsg( 0, String( "Extended gun with no replacement %d, CC:0", usGun ) );
		return( NOTHING );
	}
	else
	{
		return( NOTHING );
	}
}

UINT16 StandardGunListAmmoReplacement( UINT16 usAmmo )
{
	UINT8 ubLoop;

	if ( ExtendedGunListGun( usAmmo ) )
	{
		ubLoop = 0;
		while ( ReplacementAmmo[ ubLoop ][ 0 ] != 0 )
		{
			if ( ReplacementAmmo[ ubLoop ][ 0 ] == usAmmo )
			{
				return( ReplacementAmmo[ ubLoop ][ 1 ] );
			}
			ubLoop++;
		}
		// ERROR!
		AssertMsg( 0, String( "Extended gun with no replacement %d, CC:0", usAmmo ) );
		return( NOTHING );
	}
	else
	{
		return( NOTHING );
	}
}

BOOLEAN WeaponInHand( SOLDIERTYPE * pSoldier )
{
	if ( Item[pSoldier->inv[HANDPOS].usItem].usItemClass & (IC_WEAPON | IC_THROWN) )
	{
		if (pSoldier->inv[HANDPOS].usItem == ROCKET_RIFLE || pSoldier->inv[HANDPOS].usItem == AUTO_ROCKET_RIFLE )
		{
			if (pSoldier->inv[HANDPOS].ubImprintID != NO_PROFILE)
			{
				if (pSoldier->ubProfile != NO_PROFILE)
				{
					if (pSoldier->inv[HANDPOS].ubImprintID != pSoldier->ubProfile)
					{
						return( FALSE );
					}
				}
				else
				{
					if (pSoldier->inv[HANDPOS].ubImprintID != (NO_PROFILE + 1) )
					{
						return( FALSE );
					}
				}
			}
		}
		if (pSoldier->inv[HANDPOS].bGunStatus >= USABLE)
		{
			return( TRUE );
		}
	}
	// return -1 or some "broken" value if weapon is broken?
	return( FALSE );
}

UINT8 ItemSlotLimit( UINT16 usItem, INT8 bSlot )
{
	UINT8 ubSlotLimit;

	if ( bSlot < BIGPOCK1POS )
	{
		return( 1 );
	}
	else
	{
		ubSlotLimit = Item[usItem].ubPerPocket;
		if (bSlot >= SMALLPOCK1POS && ubSlotLimit > 1)
		{
			ubSlotLimit /= 2;
		}
		return( ubSlotLimit );
	}
}

UINT32 MoneySlotLimit( INT8 bSlot )
{
	if ( bSlot >= SMALLPOCK1POS )
	{
		return( MAX_MONEY_PER_SLOT / 2 );
	}
	else
	{
		return( MAX_MONEY_PER_SLOT );
	}
}


INT8 FindObj( SOLDIERTYPE * pSoldier, UINT16 usItem )
{
	INT8 bLoop;

	for (bLoop = 0; bLoop < NUM_INV_SLOTS; bLoop++)
	{
		if (pSoldier->inv[bLoop].usItem == usItem)
		{
			return( bLoop );
		}
	}
	return( NO_SLOT );
}

INT8 FindUsableObj( SOLDIERTYPE * pSoldier, UINT16 usItem )
{
	INT8 bLoop;

	for (bLoop = 0; bLoop < NUM_INV_SLOTS; bLoop++)
	{
		if ( pSoldier->inv[bLoop].usItem == usItem && pSoldier->inv[bLoop].bStatus[0] >= USABLE )
		{
			return( bLoop );
		}
	}
	return( NO_SLOT );
}


INT8 FindObjExcludingSlot( SOLDIERTYPE * pSoldier, UINT16 usItem, INT8 bExcludeSlot )
{
	INT8 bLoop, bSubSlot;

	for (bLoop = 0; bLoop < NUM_INV_SLOTS; bLoop++)
	{
		if (bLoop == bExcludeSlot)
			continue;
		if (pSoldier->inv[bLoop].usItem == usItem)
//SB: fix treat of empty magazine as full
			for(bSubSlot=0; bSubSlot<pSoldier->inv[bLoop].ubNumberOfObjects; bSubSlot++)
				if(pSoldier->inv[bLoop].ubShotsLeft[bSubSlot])
					return( bLoop );
	}
	return( NO_SLOT );
}

INT8 FindExactObj( SOLDIERTYPE * pSoldier, OBJECTTYPE * pObj )
{
	INT8 bLoop;

	for (bLoop = 0; bLoop < NUM_INV_SLOTS; bLoop++)
	{
		if ( (pObj == &(pSoldier->inv[bLoop])) && (memcmp( &(pSoldier->inv[bLoop]), pObj, sizeof( OBJECTTYPE ) ) == 0) )
		{
			return( bLoop );
		}
	}
	return( NO_SLOT );
}


INT8 FindObjWithin( SOLDIERTYPE * pSoldier, UINT16 usItem, INT8 bLower, INT8 bUpper )
{
	INT8	bLoop;

	for (bLoop = bLower; bLoop <= bUpper; bLoop++)
	{
		if (pSoldier->inv[bLoop].usItem == usItem)			
		{
			return( bLoop );
		}
	}
	return( ITEM_NOT_FOUND );
}

INT8 FindObjInObjRange( SOLDIERTYPE * pSoldier, UINT16 usItem1, UINT16 usItem2 )
{
	INT8		bLoop;
	UINT16	usTemp;

	if (usItem1 > usItem2 )
	{
		// swap the two...
		usTemp = usItem2;
		usItem2 = usItem1;
		usItem1 = usTemp;
	}

	for (bLoop = 0; bLoop < NUM_INV_SLOTS; bLoop++)
	{
		usTemp = pSoldier->inv[bLoop].usItem;
		if ( usTemp >= usItem1 && usTemp <= usItem2 )
		{
			return( bLoop );
		}
	}

	return( ITEM_NOT_FOUND );
}


INT8 FindObjClass( SOLDIERTYPE * pSoldier, 	UINT32 usItemClass )
{
	INT8 bLoop;

	for (bLoop = 0; bLoop < NUM_INV_SLOTS; bLoop++)
	{
		if (Item[pSoldier->inv[bLoop].usItem].usItemClass & usItemClass)
		{
			return( bLoop );
		}
	}
	return( NO_SLOT );
}

INT8 FindObjClassAfterSlot( SOLDIERTYPE * pSoldier, INT8 bStartAfter, UINT32 usItemClass )
{
	INT8 bLoop;

	for (bLoop = bStartAfter + 1; bLoop < NUM_INV_SLOTS; bLoop++)
	{
		if (Item[pSoldier->inv[bLoop].usItem].usItemClass == usItemClass)
		{
			return( bLoop );
		}
	}
	return( NO_SLOT );
}

INT8 FindAIUsableObjClass( SOLDIERTYPE * pSoldier, 	UINT32 usItemClass )
{
	// finds the first object of the specified class which does NOT have
	// the "unusable by AI" flag set.

	// uses & rather than == so that this function can search for any weapon
	INT8 bLoop;

	// This is for the AI only so:

	// Do not consider tank cannons or rocket launchers to be "guns"

	for (bLoop = 0; bLoop < NUM_INV_SLOTS; bLoop++)
	{
		if ( (Item[pSoldier->inv[bLoop].usItem].usItemClass & usItemClass) && !(pSoldier->inv[bLoop].fFlags & OBJECT_AI_UNUSABLE) && (pSoldier->inv[bLoop].bStatus[0] >= USABLE ) )
		{
			if ( usItemClass == IC_GUN && EXPLOSIVE_GUN( pSoldier->inv[bLoop].usItem ) )
			{
				continue;
			}
			return( bLoop );
		}
	}
	return( NO_SLOT );
}

INT8 FindAIUsableObjClassWithin( SOLDIERTYPE * pSoldier, 	UINT32 usItemClass, INT8 bLower, INT8 bUpper )
{
	INT8 bLoop;

	// This is for the AI only so:
	// Do not consider tank cannons or rocket launchers to be "guns"

	for (bLoop = bLower; bLoop <= bUpper; bLoop++)
	{
		if ( (Item[pSoldier->inv[bLoop].usItem].usItemClass & usItemClass) && !(pSoldier->inv[bLoop].fFlags & OBJECT_AI_UNUSABLE) && (pSoldier->inv[bLoop].bStatus[0] >= USABLE ) )
		{
			if ( usItemClass == IC_GUN && EXPLOSIVE_GUN( pSoldier->inv[bLoop].usItem ) )
			{
				continue;
			}
			return( bLoop );
		}
	}
	return( NO_SLOT );
}

INT8 FindEmptySlotWithin( SOLDIERTYPE * pSoldier, INT8 bLower, INT8 bUpper )
{
	INT8	bLoop;

	for (bLoop = bLower; bLoop <= bUpper; bLoop++)
	{
		if (pSoldier->inv[bLoop].usItem == 0)
		{
			if (bLoop == SECONDHANDPOS && Item[pSoldier->inv[HANDPOS].usItem].fFlags & ITEM_TWO_HANDED)
			{
				continue;
			}
			else
			{
				return( bLoop );
			}
		}
	}
	return( ITEM_NOT_FOUND );
}

BOOLEAN GLGrenadeInSlot(SOLDIERTYPE *pSoldier, INT8 bSlot )
{
	switch (pSoldier->inv[bSlot].usItem)
	{
		case GL_HE_GRENADE:
		case GL_TEARGAS_GRENADE:
		case GL_STUN_GRENADE:
		case GL_SMOKE_GRENADE:
			return(TRUE);
		default:
			return(FALSE);
	}
}

// for grenade launchers
INT8 FindGLGrenade( SOLDIERTYPE * pSoldier )
{
	INT8 bLoop;

	for (bLoop = 0; bLoop < NUM_INV_SLOTS; bLoop++)
	{
		if (GLGrenadeInSlot( pSoldier, bLoop ))
		{
			return( bLoop );
		}
	}
	return( NO_SLOT );
}

INT8 FindThrowableGrenade( SOLDIERTYPE * pSoldier )
{
	INT8 bLoop;
	BOOLEAN fCheckForFlares = FALSE;

	// JA2Gold: give some priority to looking for flares when at night
	// this is AI only so we can put in some customization for night
	if (GetTimeOfDayAmbientLightLevel() == NORMAL_LIGHTLEVEL_NIGHT)
	{
		if (pSoldier->bLife > (pSoldier->bLifeMax / 2))
		{
			fCheckForFlares = TRUE;
		}
	}
	if (fCheckForFlares)
	{
		// Do a priority check for flares first
		for (bLoop = 0; bLoop < NUM_INV_SLOTS; bLoop++)
		{
			if (pSoldier->inv[ bLoop ].usItem == BREAK_LIGHT)
			{
				return( bLoop );
			}
		}
	}
	
	for (bLoop = 0; bLoop < NUM_INV_SLOTS; bLoop++)
	{
		if ( (Item[ pSoldier->inv[ bLoop ].usItem ].usItemClass & IC_GRENADE) && !GLGrenadeInSlot( pSoldier, bLoop ) )
		{
			return( bLoop );
		}
	}
	return( NO_SLOT );
}

INT8 FindAttachment( OBJECTTYPE * pObj, UINT16 usItem )
{
	INT8	bLoop;

	for (bLoop = 0; bLoop < MAX_ATTACHMENTS; bLoop++)
	{
		if (pObj->usAttachItem[bLoop] == usItem)
		{
			return( bLoop );
		}
	}
	return( ITEM_NOT_FOUND );
}

INT8 FindAttachmentByClass( OBJECTTYPE * pObj, UINT32 uiItemClass )
{
	INT8	bLoop;

	for (bLoop = 0; bLoop < MAX_ATTACHMENTS; bLoop++)
	{
		if (Item[ pObj->usAttachItem[bLoop] ].usItemClass == uiItemClass)
		{
			return( bLoop );
		}
	}
	return( ITEM_NOT_FOUND );
}

INT8 FindLaunchable( SOLDIERTYPE * pSoldier, UINT16 usWeapon )
{
	INT8	bLoop;

	for (bLoop = 0; bLoop < NUM_INV_SLOTS; bLoop++)
	{
		if ( ValidLaunchable( pSoldier->inv[ bLoop ].usItem , usWeapon ) )
		{
			return( bLoop );
		}
	}
	return( ITEM_NOT_FOUND );
}

INT8 FindLaunchableAttachment( OBJECTTYPE * pObj, UINT16 usWeapon )
{
	INT8		bLoop;

	for ( bLoop = 0; bLoop < MAX_ATTACHMENTS; bLoop++ )
	{
		if ( pObj->usAttachItem[ bLoop ] != NOTHING && ValidLaunchable( pObj->usAttachItem[ bLoop ], usWeapon ) )
		{
			return( bLoop );
		}
	}

	return( ITEM_NOT_FOUND );
}



//Simple check to see if the item has any attachments
BOOLEAN ItemHasAttachments( OBJECTTYPE * pObj )
{
	if ((pObj->usAttachItem[0] == NOTHING) && (pObj->usAttachItem[1] == NOTHING) && (pObj->usAttachItem[2] == NOTHING) && (pObj->usAttachItem[3] == NOTHING))
	{
		return( FALSE );
	}
	return( TRUE );
}

// Determine if it is possible to add this attachment to the CLASS of this item
// (i.e. to any item in the class)
BOOLEAN ValidAttachmentClass( UINT16 usAttachment, UINT16 usItem )
{
	INT32 iLoop = 0;
	while( 1 )
	{
		// see comment for AttachmentInfo array for why we skip IC_NONE
		if ( AttachmentInfo[ iLoop ].uiItemClass != IC_NONE )
		{
			if ( AttachmentInfo[ iLoop ].usItem == usAttachment )
			{
				if ( AttachmentInfo[ iLoop ].uiItemClass == Item[ usItem ].usItemClass )
				{
					return( TRUE );
				}
			}
		}
		iLoop++;
		if (AttachmentInfo[iLoop].usItem == 0)
		{
			// end of the array
			break;
		}
	}
	return( FALSE );	
}

INT8 GetAttachmentInfoIndex( UINT16 usItem )
{
	INT32 iLoop = 0;

	while( 1 )
	{
		if ( AttachmentInfo[ iLoop ].usItem == usItem )
		{
			return( (INT8) iLoop );
		}
		iLoop++;
		if (AttachmentInfo[iLoop].usItem == 0)
		{
			// end of the array
			break;
		}
	}
	return( -1 );
}

//Determine if it is possible to add this attachment to the item.
//SB: this function has been modified to eliminate unceasing attach location requirement
BOOLEAN ValidAttachment( UINT16 usAttachment, UINT16 usItem )
{
	INT32 iLoop = 0;

	// look for the section of the array pertaining to this attachment...
	while( 1 )
	{
		if (Attachment[iLoop][0] == usAttachment && Attachment[iLoop][1] == usItem)
			break;
		iLoop++;
		if (Attachment[iLoop][0] == 0)
			// the proposed item cannot be attached to anything!
			return( FALSE );
	}
	return( TRUE );
}

//Determine if this item can receive this attachment.  This is different, in that it may
//be possible to have this attachment on this item, but may already have an attachment on
//it which doesn't work simultaneously with the new attachment (like a silencer and duckbill).
BOOLEAN ValidItemAttachment( OBJECTTYPE * pObj, UINT16 usAttachment, BOOLEAN fAttemptingAttachment )
{
	BOOLEAN		fSameItem = FALSE, fSimilarItems = FALSE;
	UINT16		usSimilarItem = NOTHING;

	if ( !ValidAttachment( usAttachment, pObj->usItem ) )
	{
		// check for an underslung grenade launcher attached to the gun
		if ( (FindAttachment( pObj, UNDER_GLAUNCHER ) != ITEM_NOT_FOUND) && ValidLaunchable( usAttachment, UNDER_GLAUNCHER ) )
		{
			return ( TRUE );
			/*
			if ( fAttemptingAttachment )
			{
				// if there is no other grenade attached already, then we can attach it
				if (FindAttachmentByClass( pObj, IC_GRENADE) != ITEM_NOT_FOUND)
				{
					return( FALSE );
				}
				// keep going, it can be attached to the grenade launcher
			}
			else
			{
				// logically, can be added
				return( TRUE );
			}
			*/
		}
		else
		{
			if ( fAttemptingAttachment && ValidAttachmentClass( usAttachment, pObj->usItem ) )
			{
				// well, maybe the player thought he could
				UINT16	zTemp[ 100 ];
				
				swprintf( zTemp, Message[ STR_CANT_ATTACH ], ItemNames[ usAttachment ], ItemNames[ pObj->usItem ] );
				ScreenMsg( FONT_MCOLOR_LTYELLOW, MSG_UI_FEEDBACK, zTemp );
			}

			return( FALSE );
		}
	}
	// special conditions go here
	// can't have two of the same attachment on an item
	/*
	if (FindAttachment( pObj, usAttachment ) != ITEM_NOT_FOUND)
	{
		fSameItem = TRUE;
	}
	*/

	// special code for items which won't attach if X is present
	switch( usAttachment )
	{
		case BIPOD:
			if ( FindAttachment( pObj, UNDER_GLAUNCHER) != ITEM_NOT_FOUND )
			{
				fSimilarItems = TRUE;
				usSimilarItem = UNDER_GLAUNCHER;
			}
			break;
		case UNDER_GLAUNCHER:
			if ( FindAttachment( pObj, BIPOD ) != ITEM_NOT_FOUND )
			{
				fSimilarItems = TRUE;
				usSimilarItem = BIPOD;
			}
			break;
	/*
		case LASERSCOPE:
			if (FindAttachment( pObj, SNIPERSCOPE ) != ITEM_NOT_FOUND)
			{
				return( FALSE );
			}
			break;
		case SNIPERSCOPE:
			if (FindAttachment( pObj, LASERSCOPE ) != ITEM_NOT_FOUND)
			{
				return( FALSE );
			}
			break;
			*/
		case DETONATOR:
			if( FindAttachment( pObj, REMDETONATOR ) != ITEM_NOT_FOUND )
			{
				fSameItem = TRUE;
			}
			break;
		case REMDETONATOR:
			if( FindAttachment( pObj, DETONATOR ) != ITEM_NOT_FOUND )
			{
				fSameItem = TRUE;
			}
			break;
	}

	if (fAttemptingAttachment)	
	{
		if (fSameItem)
		{
			ScreenMsg( FONT_MCOLOR_LTYELLOW, MSG_UI_FEEDBACK, Message[ STR_ATTACHMENT_ALREADY ] );
			return( FALSE );
		} 
		else if (fSimilarItems)
		{
			ScreenMsg( FONT_MCOLOR_LTYELLOW, MSG_UI_FEEDBACK, Message[ STR_CANT_USE_TWO_ITEMS ], ItemNames[ usSimilarItem ], ItemNames[ usAttachment ] );
			return( FALSE );
		}
	}

	return( TRUE );
}

//Determines if it is possible to equip this weapon with this ammo.
BOOLEAN ValidAmmoType( UINT16 usItem, UINT16 usAmmoType )
{
	if (Item[usItem].usItemClass == IC_GUN && Item[usAmmoType].usItemClass == IC_AMMO)
	{
		if (Weapon[ Item[usItem].ubClassIndex].ubCalibre == Magazine[Item[usAmmoType].ubClassIndex].ubCalibre)
		{
			return( TRUE );
		}
	}
	return( FALSE );
}

BOOLEAN CompatibleFaceItem( UINT16 usItem1, UINT16 usItem2 )
{
	INT32 iLoop = 0;

	// look for the section of the array pertaining to this attachment...
	while( 1 )
	{
		if (CompatibleFaceItems[iLoop][0] == usItem1)
		{
			break;
		}
		iLoop++;
		if (CompatibleFaceItems[iLoop][0] == 0)
		{
			// the proposed item cannot fit with anything!
			return( FALSE );
		}
	}
	// now look through this section for the item in question
	while( 1 )
	{
		if (CompatibleFaceItems[iLoop][1] == usItem2)
		{
			break;
		}
		iLoop++;
		if (CompatibleFaceItems[iLoop][0] != usItem1)
		{
			// the proposed item cannot be attached to the item in question
			return( FALSE );
		}
	}
	return( TRUE );
}


//Determines if this item is a two handed item.
BOOLEAN TwoHandedItem( UINT16 usItem )
{
	if (Item[usItem].fFlags & ITEM_TWO_HANDED)
	{
		return( TRUE );
	}
	return FALSE;
}

BOOLEAN ValidLaunchable( UINT16 usLaunchable, UINT16 usItem )
{
	INT32 iLoop = 0;

	// look for the section of the array pertaining to this launchable item...
	while( 1 )
	{
		if (Launchable[iLoop][0] == usLaunchable)
		{
			break;
		}
		iLoop++;
		if (Launchable[iLoop][0] == 0)
		{
			// the proposed item cannot be attached to anything!
			return( FALSE );
		}
	}
	// now look through this section for the item in question
	while( 1 )
	{
		if (Launchable[iLoop][1] == usItem)
		{
			break;
		}
		iLoop++;
		if (Launchable[iLoop][0] != usLaunchable)
		{
			// the proposed item cannot be attached to the item in question
			return( FALSE );
		}
	}
	return( TRUE );
}

BOOLEAN ValidItemLaunchable( OBJECTTYPE * pObj, UINT16 usAttachment )
{
	if ( !ValidLaunchable( usAttachment, pObj->usItem ) )
	{
		return( FALSE );
	}
	// if we can find another of the same class as the attachment, it's not possible
	if ( FindAttachmentByClass( pObj, Item[ usAttachment ].usItemClass ) != NO_SLOT )
	{
		return( FALSE );
	}
	return( TRUE );
}


UINT16 GetLauncherFromLaunchable( UINT16 usLaunchable )
{
	INT32 iLoop = 0;
	UINT16 usItem = NOTHING;

	// look for the section of the array pertaining to this launchable item...
	while( 1 )
	{
		if (Launchable[iLoop][0] == usLaunchable)
		{
			break;
		}
		iLoop++;
		if (Launchable[iLoop][0] == 0)
		{
			// the proposed item cannot be attached to anything!
			return( NOTHING );
		}
	}

	return( Launchable[iLoop][1] );
}

int GetMagazineItem(UINT8 ubCaliber,UINT8 ubFeedType, UINT8 ubMagSize, UINT ubAmmoType);

BOOLEAN EvaluateValidMerge( UINT16 usMerge, UINT16 usItem, UINT16 * pusResult, UINT8 * pubType /*SB*/, OBJECTTYPE * pObject )
{
	// NB "usMerge" is the object being merged with (e.g. compound 18)
	// "usItem" is the item being merged "onto" (e.g. kevlar vest)
	INT32 iLoop = 0;
	//<SB>: merge ammunition
	if (Item[ usItem ].usItemClass == IC_AMMO && Item[ usMerge ].usItemClass == IC_AMMO && (usMerge == usItem || 
		Magazine[Item[ usItem ].ubClassIndex].ubCalibre == Magazine[Item[ usMerge ].ubClassIndex].ubCalibre &&
		 (Magazine[Item[ usItem ].ubClassIndex].ubAmmoType == Magazine[Item[ usMerge ].ubClassIndex].ubAmmoType ||
		    !pObject->ubShotsLeft[0])
		)
	)
	{
//		*pusResult = usItem;
		*pusResult = GetMagazineItem(
							Magazine[Item[ usItem ].ubClassIndex].ubCalibre,
							Magazine[Item[ usItem ].ubClassIndex].ubFeedType,
							Magazine[Item[ usItem ].ubClassIndex].ubMagSize,
							Magazine[Item[ usMerge ].ubClassIndex].ubAmmoType
						);
		*pubType = COMBINE_POINTS;
		return( TRUE );
	}
	//</SB>: merge ammunition
	// look for the section of the array pertaining to this Merge...
	while( 1 )
	{
		if (Merge[iLoop][0] == usMerge)
			break;
		iLoop++;
		if (Merge[iLoop][0] == 0)
			// the proposed item cannot be merged with anything!
			return( FALSE );
	}
	// now look through this section for the item in question
	while( 1 )
	{
		if (Merge[iLoop][1] == usItem)
			break;
		iLoop++;
		if (Merge[iLoop][0] != usMerge)
			// the proposed item cannot be merged with the item in question
			return( FALSE );
		}
	*pusResult = Merge[iLoop][2];
	*pubType = (UINT8) Merge[iLoop][3];
	return( TRUE );
}

BOOLEAN ValidMerge( UINT16 usMerge, UINT16 usItem /*SB*/, OBJECTTYPE * pObject )
{
	UINT16	usIgnoreResult;
	UINT8		ubIgnoreType;
	return( EvaluateValidMerge( usMerge, usItem, &usIgnoreResult, &ubIgnoreType, pObject ) );
}

UINT8 CalculateObjectWeight( OBJECTTYPE *pObject )
{
	INT32 cnt;
	UINT16 usWeight;
	INVTYPE * pItem;

	pItem = &(Item[ pObject->usItem ]);

	// Start with base weight
	usWeight = pItem->ubWeight;

	if (pItem->ubPerPocket < 2)
	{
		// account for any attachments
		for ( cnt = 0; cnt < MAX_ATTACHMENTS; cnt++ )
			if (pObject->usAttachItem[cnt] != NOTHING )
				usWeight += Item[ pObject->usAttachItem[cnt] ].ubWeight;

		// add in weight of ammo
		if (Item[ pObject->usItem ].usItemClass == IC_GUN && pObject->ubGunShotsLeft > 0)
			usWeight += Item[ pObject->usGunAmmoItem ].ubWeight;
	}
	
	// make sure it really fits into that UINT8, in case we ever add anything real heavy with attachments/ammo
	Assert(usWeight <= 255);

	return( (UINT8) usWeight );
}

UINT32 CalculateCarriedWeight( SOLDIERTYPE * pSoldier )
{
	UINT32	uiTotalWeight = 0;
	UINT32	uiPercent;
	UINT8		ubLoop;
	UINT16  usWeight;
	UINT8		ubStrengthForCarrying;

	for( ubLoop = 0; ubLoop < NUM_INV_SLOTS; ubLoop++)
	{
		usWeight = pSoldier->inv[ubLoop].ubWeight;
		if (Item[ pSoldier->inv[ubLoop].usItem ].ubPerPocket > 1)
			// account for # of items
			usWeight *= pSoldier->inv[ubLoop].ubNumberOfObjects;
		uiTotalWeight += usWeight;

	}
	// for now, assume soldiers can carry 1/2 their strength in KGs without penalty.
	// instead of multiplying by 100 for percent, and then dividing by 10 to account 
	// for weight units being in 10ths of kilos, not kilos... we just start with 10 instead of 100!
	ubStrengthForCarrying = EffectiveStrength( pSoldier );
	if ( ubStrengthForCarrying > 80 ) 
		ubStrengthForCarrying += (ubStrengthForCarrying - 80);
	uiPercent = (10 * uiTotalWeight) / ( ubStrengthForCarrying / 2 );
	return( uiPercent );

}

void DeleteObj(OBJECTTYPE * pObj )
{
	memset( pObj, 0, sizeof(OBJECTTYPE) );
}

void CopyObj( OBJECTTYPE * pSourceObj, OBJECTTYPE * pTargetObj )
{
	memcpy( pTargetObj, pSourceObj, sizeof( OBJECTTYPE ) );
}

void SwapObjs( OBJECTTYPE * pObj1, OBJECTTYPE * pObj2 )
{
	OBJECTTYPE		Temp;

	memcpy( &Temp, pObj1, sizeof( OBJECTTYPE ) );
	memcpy( pObj1, pObj2, sizeof( OBJECTTYPE ) );
	memcpy( pObj2, &Temp, sizeof( OBJECTTYPE ) );
/*
	//if we are in the shop keeper interface, switch the items
	if( guiTacticalInterfaceFlags & INTERFACE_SHOPKEEP_INTERFACE )
	{
		memset( &gMoveingItem, 0, sizeof( INVENTORY_IN_SLOT ) );
		gMoveingItem.fActive = TRUE;
		gMoveingItem.sItemIndex = pObj1->usItem;

		gMoveingItem.ubLocationOfObject = PLAYERS_INVENTORY;
		gMoveingItem.ubIdOfMercWhoOwnsTheItem = gpItemPointerSoldier->ubProfile;

		//Get the item from the slot.
		memcpy( &gMoveingItem.ItemObject, &pObj1, sizeof( OBJECTTYPE ) );

	}
*/
}

void RemoveObjFrom( OBJECTTYPE * pObj, UINT8 ubRemoveIndex )
{
	// remove 1 object from an OBJECTTYPE, starting at index bRemoveIndex
	UINT8 ubLoop;

	if (pObj->ubNumberOfObjects < ubRemoveIndex)
	{
		// invalid index!
		return;
	}
	else if (pObj->ubNumberOfObjects == 1)
	{
		// delete!
		DeleteObj( pObj );
	} 
	else
	{
		// shift down all the values that should be down
		for (ubLoop = ubRemoveIndex + 1; ubLoop < pObj->ubNumberOfObjects; ubLoop++)
		{
			pObj->bStatus[ubLoop - 1] = pObj->bStatus[ubLoop];
		}
		// and set the upper value to 0
		pObj->bStatus[pObj->ubNumberOfObjects - 1] = 0;
		// make the number of objects recorded match the array
		pObj->ubNumberOfObjects--;
	}
}

void RemoveObjs( OBJECTTYPE * pObj, UINT8 ubNumberToRemove )
{
	// remove a certain number of objects from an OBJECTTYPE, starting at index 0
	UINT8 ubLoop;

	if (ubNumberToRemove == 0)
	{
		return;
	}
	if (ubNumberToRemove >= pObj->ubNumberOfObjects)
	{
		// delete!
		DeleteObj( pObj );
	}
	else
	{
		for (ubLoop = 0; ubLoop < ubNumberToRemove; ubLoop++)
		{
			RemoveObjFrom( pObj, 0 );
		}
		pObj->ubWeight = CalculateObjectWeight( pObj );
	}
}

void GetObjFrom( OBJECTTYPE * pObj, UINT8 ubGetIndex, OBJECTTYPE * pDest )
{
	if (!pDest || ubGetIndex >= pObj->ubNumberOfObjects)
	{
		return;
	}
	if (pObj->ubNumberOfObjects == 1)
	{
		memcpy( pDest, pObj, sizeof( OBJECTTYPE ) );
		DeleteObj( pObj );	
	}
	else
	{
		pDest->usItem = pObj->usItem;
		pDest->bStatus[0] = pObj->bStatus[ubGetIndex];
		pDest->ubNumberOfObjects = 1;
		pDest->ubWeight = CalculateObjectWeight( pDest );
		RemoveObjFrom( pObj, ubGetIndex );
		pObj->ubWeight = CalculateObjectWeight( pObj );
	}
}

void SwapWithinObj( OBJECTTYPE * pObj, UINT8 ubIndex1, UINT8 ubIndex2 )
{
	INT8 bTemp;

	if (pObj->ubNumberOfObjects >= ubIndex1 || pObj->ubNumberOfObjects >= ubIndex1)
	{
		return;
	}
	
	bTemp = pObj->bStatus[ubIndex1];
	pObj->bStatus[ubIndex1] = pObj->bStatus[ubIndex2];
	pObj->bStatus[ubIndex2] = bTemp;
}

void DamageObj( OBJECTTYPE * pObj, INT8 bAmount )
{
	if (bAmount >= pObj->bStatus[0])
	{
		pObj->bStatus[0] = 1;
	}
	else
	{
		pObj->bStatus[0] -= bAmount;
	}
}

void StackObjs( OBJECTTYPE * pSourceObj, OBJECTTYPE * pTargetObj, UINT8 ubNumberToCopy )
{
	UINT8		ubLoop;

	// copy over N status values
	for (ubLoop = 0; ubLoop < ubNumberToCopy; ubLoop++)
	{
		pTargetObj->bStatus[ubLoop + pTargetObj->ubNumberOfObjects] = pSourceObj->bStatus[ubLoop ];
	}

	// now in the source object, move the rest down N places
	for (ubLoop = ubNumberToCopy; ubLoop < pSourceObj->ubNumberOfObjects; ubLoop++)
	{
		pSourceObj->bStatus[ubLoop - ubNumberToCopy] = pSourceObj->bStatus[ubLoop];
	}

	pTargetObj->ubNumberOfObjects += ubNumberToCopy;
	RemoveObjs( pSourceObj, ubNumberToCopy );
	pSourceObj->ubWeight = CalculateObjectWeight( pSourceObj );
	pTargetObj->ubWeight = CalculateObjectWeight( pTargetObj );
}

void CleanUpStack( OBJECTTYPE * pObj, OBJECTTYPE * pCursorObj )
{
	INT8	bLoop, bLoop2;
	INT8	bMaxPoints, bPointsToMove;

	if ( !(Item[ pObj->usItem ].usItemClass & IC_AMMO || Item[ pObj->usItem ].usItemClass & IC_KIT || Item[ pObj->usItem ].usItemClass & IC_MEDKIT ) )
	{
		return;
	}

	if ( Item[ pObj->usItem ].usItemClass & IC_AMMO )
	{
		bMaxPoints = Magazine[ Item[ pObj->usItem ].ubClassIndex ].ubMagSize;
	}
	else
	{
		bMaxPoints = 100;
	}

	if ( pCursorObj && pCursorObj->usItem == pObj->usItem )
	{
		for ( bLoop = (INT8) pCursorObj->ubNumberOfObjects - 1; bLoop >= 0; bLoop-- )
		{
			if ( pCursorObj->bStatus[ bLoop ] > 0 )
			{
				// take the points here and distribute over the lower #d items
				for ( bLoop2 = pObj->ubNumberOfObjects - 1; bLoop2 >= 0; bLoop2-- )
				{
					if ( pObj->bStatus[ bLoop2 ] < bMaxPoints )
					{
						bPointsToMove = bMaxPoints - pObj->bStatus[ bLoop2 ];
						bPointsToMove = __min( bPointsToMove, pCursorObj->bStatus[ bLoop ] );

						pObj->bStatus[ bLoop2 ] += bPointsToMove;

						pCursorObj->bStatus[ bLoop ] -= bPointsToMove;
						if ( pCursorObj->bStatus[ bLoop ] == 0 )
						{
							// done!
							pCursorObj->ubNumberOfObjects--;
							break;
						}
					}
				}
			}
		}
	}

	for ( bLoop = (INT8) pObj->ubNumberOfObjects - 1; bLoop >= 0; bLoop-- )
	{
		if ( pObj->bStatus[ bLoop ] > 0 )
		{
			// take the points here and distribute over the lower #d items
			for ( bLoop2 = bLoop - 1; bLoop2 >= 0; bLoop2-- )
			{
				if ( pObj->bStatus[ bLoop2 ] < bMaxPoints )
				{
					bPointsToMove = bMaxPoints - pObj->bStatus[ bLoop2 ];
					bPointsToMove = __min( bPointsToMove, pObj->bStatus[ bLoop ] );

					pObj->bStatus[ bLoop2 ] += bPointsToMove;

					pObj->bStatus[ bLoop ] -= bPointsToMove;
					if ( pObj->bStatus[ bLoop ] == 0 )
					{
						// done!
						pObj->ubNumberOfObjects--;
						break;
					}
				}
			}
		}
	}

}


BOOLEAN PlaceObjectAtObjectIndex( OBJECTTYPE * pSourceObj, OBJECTTYPE * pTargetObj, UINT8 ubIndex )
{
	INT8 bTemp;

	if (pSourceObj->usItem != pTargetObj->usItem)
	{
		return( TRUE );
	}
	if (ubIndex < pTargetObj->ubNumberOfObjects)
	{
		// swap
		bTemp = pSourceObj->bStatus[0];
		pSourceObj->bStatus[0] = pTargetObj->bStatus[ubIndex];
		pTargetObj->bStatus[ubIndex] = bTemp;
		return( TRUE );
	}
	else
	{
		// add to end
		StackObjs( pSourceObj, pTargetObj, 1 );
		return( FALSE );
	}
}

//<SB> Now there's no need in this
int GetMagazineItem(UINT8 ubCaliber,UINT8 ubFeedType, UINT8 ubMagSize, UINT ubAmmoType)
{
	int i;
	for( i = 0; i<MAXITEMS; i++)
	{
		if(Item[i].usItemClass == IC_AMMO && 
			Magazine[Item[i].ubClassIndex].ubCalibre == ubCaliber &&
			Magazine[Item[i].ubClassIndex].ubMagSize == ubMagSize &&
			Magazine[Item[i].ubClassIndex].ubAmmoType == ubAmmoType &&
			Magazine[Item[i].ubClassIndex].ubFeedType == ubFeedType
		)
			return i;
	}
	ScreenMsg(FONT_RED, MSG_ERROR, L":     :%d :%d :%d", ubCaliber, ubMagSize, ubAmmoType);
	return 0;
}

#define FEED_BOX	255

int GetAmmoBoxItem(UINT8 ubCaliber,UINT ubAmmoType)
{
	int i;
	for( i = 0; i<MAXITEMS; i++)
	{
		if(Item[i].usItemClass == IC_AMMO && 
			Magazine[Item[i].ubClassIndex].ubCalibre == ubCaliber &&
			Magazine[Item[i].ubClassIndex].ubFeedType == FEED_BOX &&
			Magazine[Item[i].ubClassIndex].ubAmmoType == ubAmmoType
		)
			return i;
	}
	ScreenMsg(FONT_RED, MSG_ERROR, L":     :%d :%d", ubCaliber, ubAmmoType);
	return 0;
}

#define RELOAD_NONE 0
#define RELOAD_INSERT_MAG 1
#define RELOAD_SWAP_MAG 2
#define RELOAD_SWAP_AMMO 3
#define RELOAD_TOPOFF_AMMO 4

//<SB> this function was totally rewritten	due to new gun feed system
BOOLEAN ReloadGun( SOLDIERTYPE * pSoldier, OBJECTTYPE * pGun, OBJECTTYPE * pAmmo )
{
	OBJECTTYPE		OldAmmo;
	UINT8			ubBulletsToMove;
	INT8			bAPs;
	//	UINT16			usReloadSound;
	LPTSTR			tsReloadSound;
	BOOLEAN			fSameAmmoType;
//	BOOLEAN			fSameMagazineSize;
	BOOLEAN			fSameFeedType;
	BOOLEAN			fReloadingWithStack;
//	BOOLEAN			fEmptyGun;
	INT8			bReloadType;
//	UINT16			usNewAmmoItem;
	UINT8			ubMagSize;
	WEAPONTYPE *	pGunType = Weapon + Item[pGun->usItem].ubClassIndex;
	MAGTYPE *		pMagType = Magazine + Item[pAmmo->usItem].ubClassIndex;
	INT8			bMaxMagSubSlot, bSubSlot;

	if ( (gTacticalStatus.uiFlags & TURNBASED) && (gTacticalStatus.uiFlags & INCOMBAT) )
	{
		bAPs = GetAPsToReloadGunWithAmmo( pGun, pAmmo );
		if ( !EnoughPoints( pSoldier, bAPs, 0,TRUE ) )
			return( FALSE );
	}
	if ( Item[ pGun->usItem ].usItemClass == IC_LAUNCHER || pGun->usItem == TANK_CANNON )
		if ( AttachObject( pSoldier, pGun, pAmmo ) == FALSE )
			// abort
			return( FALSE );
		else ;
	else
	{
		// record old ammo
		memset( &OldAmmo, 0, sizeof( OBJECTTYPE ));
		OldAmmo.usItem = pGun->usGunAmmoItem;
		OldAmmo.ubNumberOfObjects = 1;
		OldAmmo.ubShotsLeft[0] = pGun->ubGunShotsLeft;

		if( !pGun->usGunAmmoItem && !pGunType->ubFixedMag)
		{
//			if( pMagType->ubFeedType == FEED_BOX )
			if( pMagType->ubFeedType != pGunType->ubFeedType )
				return( FALSE );
			bReloadType = RELOAD_INSERT_MAG;
		}
		else
		{
			fReloadingWithStack = (pAmmo->ubNumberOfObjects > 1);
			fSameAmmoType = !pGun->ubGunShotsLeft || ( GUN_AMMO_TYPE(pGun) == Magazine[Item[pAmmo->usItem].ubClassIndex].ubAmmoType );
			fSameFeedType = pGunType->ubFeedType == pMagType->ubFeedType && !pGunType->ubFixedMag;

			if( fSameFeedType )
				if( fSameAmmoType )
					if ( (gTacticalStatus.uiFlags & TURNBASED) && (gTacticalStatus.uiFlags & INCOMBAT))
						bReloadType = RELOAD_SWAP_MAG;
					else
						bReloadType = RELOAD_TOPOFF_AMMO;
				else
					bReloadType = RELOAD_SWAP_MAG;
			else
				if( fSameAmmoType )
					bReloadType = RELOAD_TOPOFF_AMMO;
				else
					if ( (gTacticalStatus.uiFlags & TURNBASED) && (gTacticalStatus.uiFlags & INCOMBAT))
						return FALSE;
					else
						bReloadType = RELOAD_SWAP_AMMO;
		}

		bMaxMagSubSlot = 0;
		for(bSubSlot = 0; bSubSlot < pAmmo->ubNumberOfObjects; bSubSlot++)
			if(pAmmo->ubShotsLeft[bSubSlot] > pAmmo->ubShotsLeft[bMaxMagSubSlot])
				bMaxMagSubSlot = bSubSlot;
		if(!pAmmo->ubShotsLeft[bMaxMagSubSlot] && bReloadType!=RELOAD_INSERT_MAG)
			return FALSE;

		//	bolt may don't hold open
		if ( !(pGunType->ubBoltHoldOpen || OldAmmo.ubShotsLeft[0]) )
			pGun->ubGunState &= ~GS_CARTRIDGE_IN_CHAMBER;

		switch( bReloadType )
		{

		case RELOAD_INSERT_MAG:
			pGun->ubGunShotsLeft = pAmmo->ubShotsLeft[bMaxMagSubSlot];
//			pGun->ubGunAmmoType = pMagType->ubAmmoType;
			pGun->usGunAmmoItem = pAmmo->usItem;
			RemoveObjFrom( pAmmo, bMaxMagSubSlot );
			break;

		case RELOAD_SWAP_MAG:
			pGun->ubGunShotsLeft = pAmmo->ubShotsLeft[bMaxMagSubSlot];
//			pGun->ubGunAmmoType = pMagType->ubAmmoType;
			pGun->usGunAmmoItem = pAmmo->usItem;
			if (fReloadingWithStack)
			{
				RemoveObjFrom( pAmmo, bMaxMagSubSlot );
				if (fSameAmmoType)
				{
					// add to end of stack
					StackObjs( &OldAmmo, pAmmo, 1 );
				}
				else
					// Copying the old ammo to the cursor in turnbased could screw up for the player
					// (suppose his inventory is full!)
//					if ( (gTacticalStatus.uiFlags & TURNBASED) && (gTacticalStatus.uiFlags & INCOMBAT) && !EnoughPoints( pSoldier, (INT8) (bAPs + AP_PICKUP_ITEM), 0, FALSE ) )
					{
						// try autoplace
						if ( !AutoPlaceObject( pSoldier, &OldAmmo, FALSE ) )
							// put it on the ground
							AddItemToPool( pSoldier->sGridNo, &OldAmmo, 1, pSoldier->bLevel, 0 , -1 );
						// delete the object now in the cursor
						//DeleteObj( pAmmo );
					}
				pAmmo->ubWeight = CalculateObjectWeight( pAmmo );
			}
			else
				// copy the old ammo to the cursor
				memcpy( pAmmo, &OldAmmo, sizeof( OBJECTTYPE ) );
			break;

		case RELOAD_SWAP_AMMO:
			if ( (gTacticalStatus.uiFlags & TURNBASED) && (gTacticalStatus.uiFlags & INCOMBAT))
				return FALSE;
			ubMagSize = Weapon[Item[pGun->usItem].ubClassIndex].ubFixedMag?
				Weapon[Item[pGun->usItem].ubClassIndex].ubMagSize:
				Magazine[Item[pGun->usGunAmmoItem].ubClassIndex].ubMagSize;
			ubBulletsToMove = __min( pAmmo->ubShotsLeft[bMaxMagSubSlot], ubMagSize );

			pGun->ubGunShotsLeft = ubBulletsToMove;
//			pGun->ubGunAmmoType = pMagType->ubAmmoType;
			if(pGunType->ubFixedMag)
				pGun->usGunAmmoItem = GetAmmoBoxItem(pGunType->ubCalibre,pMagType->ubAmmoType);
			else
				pGun->usGunAmmoItem = GetMagazineItem(pGunType->ubCalibre,pGunType->ubFeedType,ubMagSize,pMagType->ubAmmoType);
			//SB: make as more old ammo boxes as we need
			OldAmmo.usItem = GetAmmoBoxItem(pMagType->ubCalibre,Magazine[Item[OldAmmo.usItem].ubClassIndex].ubAmmoType);
			while( (int)OldAmmo.ubShotsLeft[0] - (int)Magazine[Item[OldAmmo.usItem].ubClassIndex].ubMagSize > 0 )
			{
				OldAmmo.ubShotsLeft[0] -= Magazine[Item[OldAmmo.usItem].ubClassIndex].ubMagSize;
				OldAmmo.ubShotsLeft[OldAmmo.ubNumberOfObjects] = Magazine[Item[OldAmmo.usItem].ubClassIndex].ubMagSize;
				OldAmmo.ubNumberOfObjects++;
			}
			OldAmmo.ubWeight = CalculateObjectWeight( pAmmo );
			//SB: remove new ammo if needed
			pAmmo->ubShotsLeft[bMaxMagSubSlot] -= ubBulletsToMove;
			if( !pAmmo->ubShotsLeft[bMaxMagSubSlot] && pMagType->ubFeedType == FEED_BOX )
				if( fReloadingWithStack )
				{
					RemoveObjFrom( pAmmo, bMaxMagSubSlot );
					pAmmo->ubWeight = CalculateObjectWeight( pAmmo );
				}
				else
					DeleteObj( pAmmo );
			//SB: place old ammo to cursor or inventory
			if( pAmmo->usItem )
				// try autoplace
				if ( !AutoPlaceObject( pSoldier, &OldAmmo, FALSE ) )
					// put it on the ground
					AddItemToPool( pSoldier->sGridNo, &OldAmmo, 1, pSoldier->bLevel, 0 , -1 );				
				else ;
			else
				// copy to cursor
				memcpy( pAmmo, &OldAmmo, sizeof( OBJECTTYPE ) );
			break;

		case RELOAD_TOPOFF_AMMO:
			ubMagSize = Weapon[Item[pGun->usItem].ubClassIndex].ubFixedMag?
				Weapon[Item[pGun->usItem].ubClassIndex].ubMagSize:
				Magazine[Item[pGun->usGunAmmoItem].ubClassIndex].ubMagSize;
			ubBulletsToMove = __min( pAmmo->ubShotsLeft[bMaxMagSubSlot], ubMagSize - pGun->ubGunShotsLeft );
			if ( ubBulletsToMove < 1 )
				return FALSE;
			//Multiple cartridge topoff in TB can performs speedloader/clip only, that's what we need this check for feedtype
			if ( (gTacticalStatus.uiFlags & TURNBASED) && (gTacticalStatus.uiFlags & INCOMBAT) && pGunType->ubFeedType != pMagType->ubFeedType )
				ubBulletsToMove = 1;
			if(pGunType->ubFixedMag)
				pGun->usGunAmmoItem = GetAmmoBoxItem(pGunType->ubCalibre,pMagType->ubAmmoType);
			else
				pGun->usGunAmmoItem = GetMagazineItem(pGunType->ubCalibre,pGunType->ubFeedType,ubMagSize,pMagType->ubAmmoType);
//			pGun->ubGunAmmoType = pMagType->ubAmmoType;
			pGun->ubGunShotsLeft += ubBulletsToMove;
			pAmmo->ubShotsLeft[bMaxMagSubSlot] -= ubBulletsToMove;
			if( !pAmmo->ubShotsLeft[bMaxMagSubSlot] && pMagType->ubFeedType == FEED_BOX )
				if( fReloadingWithStack )
				{
					RemoveObjFrom( pAmmo, bMaxMagSubSlot );
					pAmmo->ubWeight = CalculateObjectWeight( pAmmo );
				}
				else
					DeleteObj( pAmmo );
			break;
		}

	}

	// OK, let's play a sound of reloading too...
	// If this guy is visible...
	if ( pSoldier->bVisible != -1 )
	{
		// Play some effects!
		tsReloadSound	= pGunType->tsReloadSound;
		if ( *tsReloadSound && !IsAutoResolveActive() )
			SBStrPlayJA2Sample( tsReloadSound, RATE_11025, HIGHVOLUME, 1, MIDDLEPAN );	
	}

	if (pSoldier->bTeam == gbPlayerNum)
		// spit out a message if this is one of our folks reloading
		ScreenMsg( FONT_MCOLOR_LTYELLOW, MSG_INTERFACE, Message[STR_PLAYER_RELOADS], pSoldier->name );

	DeductPoints( pSoldier, bAPs, 0 );
	pGun->ubWeight = CalculateObjectWeight( pGun );

	if ( pGun->bGunAmmoStatus >= 0 )
		// make sure gun ammo status is 100, if gun isn't jammed
		pGun->bGunAmmoStatus = 100;

	return( TRUE );
}

BOOLEAN SBEmptyMagazine( OBJECTTYPE * pMagazine, OBJECTTYPE *pAmmo )
{
//	LPCTSTR tsReloadSound;
	UINT8 ubBulletsToMove;

	CHECKF( pAmmo != NULL );

	if ( pMagazine->ubShotsLeft[0] )
	{
		// start by erasing ammo item, just in case...
		DeleteObj( pAmmo );

		pAmmo->usItem					= GetAmmoBoxItem(
														Magazine[Item[pMagazine->usItem].ubClassIndex].ubCalibre,
														Magazine[Item[pMagazine->usItem].ubClassIndex].ubAmmoType
												);
		ubBulletsToMove				= __min(Magazine[Item[pAmmo->usItem].ubClassIndex].ubMagSize, pMagazine->ubShotsLeft[0]);
		pAmmo->ubShotsLeft[0]		= ubBulletsToMove;

		pAmmo->ubNumberOfObjects	= 1;

		pMagazine->ubShotsLeft[0]	-= ubBulletsToMove;

		pMagazine->ubWeight = CalculateObjectWeight( pMagazine );

		return( TRUE );
	}
	else
	{
		return( FALSE );
	}
}
//</SB>

BOOLEAN EmptyWeaponMagazine( OBJECTTYPE * pWeapon, OBJECTTYPE *pAmmo )
{
	LPTSTR tsReloadSound;

	CHECKF( pAmmo != NULL );
//<SB> there can be magazine, not gun
	if(Item[pWeapon->usItem].usItemClass & IC_AMMO)
		return SBEmptyMagazine( pWeapon, pAmmo );
//0.98.21 BUGFIX empty ammo box can be ejected from weapon with fixed magazine
	if ( pWeapon->usGunAmmoItem && (!Weapon[Item[pWeapon->usItem].ubClassIndex].ubFixedMag || pWeapon->ubGunShotsLeft) )
//	if ( pWeapon->usGunAmmoItem )
	{
//</SB>
		// start by erasing ammo item, just in case...
		DeleteObj( pAmmo );

		pAmmo->ubShotsLeft[0]			= pWeapon->ubGunShotsLeft;
		pAmmo->usItem							= pWeapon->usGunAmmoItem;
		pAmmo->ubNumberOfObjects	= 1;

		pWeapon->ubGunShotsLeft		= 0;
//		pWeapon->ubGunAmmoType	  = 0;
		pWeapon->usGunAmmoItem		= NONE; // leaving the ammo item the same for auto-reloading purposes

		// Play some effects!
		tsReloadSound	= Weapon[ Item[ pWeapon->usItem].ubClassIndex ].tsReloadSound;

		if ( *tsReloadSound )
		{
			SBStrPlayJA2Sample( tsReloadSound, RATE_11025, HIGHVOLUME, 1, MIDDLEPAN );	
		}

		pWeapon->ubWeight = CalculateObjectWeight( pWeapon );

		return( TRUE );
	}
	else
	{
		return( FALSE );
	}
}

/*
BOOLEAN ReloadLauncher( OBJECTTYPE * pLauncher, OBJECTTYPE * pAmmo )
{
	BOOLEAN			fOldAmmo;
	OBJECTTYPE	OldAmmo;

	if (pLauncher->ubGunShotsLeft == 0)
	{
		fOldAmmo = FALSE;
	}
	else
	{
		if (pAmmo->ubNumberOfObjects > 1)
		{
			// can't do the swap out to the cursor
			return( FALSE );
		}
		// otherwise temporarily store the launcher's old ammo
		memset( &OldAmmo, 0, sizeof( OBJECTTYPE ));
		fOldAmmo = TRUE;
		OldAmmo.usItem = pLauncher->usGunAmmoItem;
		OldAmmo.ubNumberOfObjects = 1;
		OldAmmo.bStatus[0] = pLauncher->bGunAmmoStatus;
	}

	// put the new ammo in the gun
	pLauncher->usGunAmmoItem = pAmmo->usItem;
	pLauncher->ubGunShotsLeft = 1;
	pLauncher->ubGunAmmoType = AMMO_GRENADE;
	pLauncher->bGunAmmoStatus = pAmmo->bStatus[0];


	if (fOldAmmo)
	{
		// copy the old ammo back to the item in the cursor
		memcpy( pAmmo, &OldAmmo, sizeof( OBJECTTYPE ) );
	}
	else
	{
		// reduce the number of objects in the cursor by 1
		RemoveObjs( pAmmo, 1 );
	}
	return( TRUE );
}
*/
//<SB>
INT8 FindAmmo( SOLDIERTYPE * pSoldier, UINT8 ubCalibre, UINT8 ubFeedType, INT8 bExcludeSlot )
{
	INT8				bLoop;
	INVTYPE *		pItem;
	INT8				bSubSlot;

	for (bLoop = HANDPOS; bLoop < NUM_INV_SLOTS; bLoop++)
	{
		if (bLoop == bExcludeSlot)
			continue;
		pItem = &(Item[pSoldier->inv[bLoop].usItem]);
		if (pItem->usItemClass == IC_AMMO && Magazine[pItem->ubClassIndex].ubCalibre == ubCalibre &&
				(Magazine[pItem->ubClassIndex].ubFeedType == ubFeedType || ubFeedType == ANY_MAGSIZE)
			)
			for(bSubSlot=0; bSubSlot<pSoldier->inv[bLoop].ubNumberOfObjects; bSubSlot++)
				if(pSoldier->inv[bLoop].ubShotsLeft[bSubSlot])
					return( bLoop );
	}
	return( NO_SLOT );
}
//</SB>

INT8 FindAmmoToReload( SOLDIERTYPE * pSoldier, INT8 bWeaponIn, INT8 bExcludeSlot )
{
	OBJECTTYPE *	pObj;
	INT8					bSlot;

	if (pSoldier == NULL)
	{
		return( NO_SLOT );
	}
	pObj = &(pSoldier->inv[bWeaponIn]);
//<SB> manual recharge
	if (pObj->ubGunShotsLeft && !(pObj->ubGunState & GS_CARTRIDGE_IN_CHAMBER) )
		return bWeaponIn;
//</SB>
	if ( Item[pObj->usItem].usItemClass == IC_GUN && pObj->usItem != TANK_CANNON )
	{
		// look for same ammo as before
		if( pObj->usGunAmmoItem )
		{
			bSlot = FindObjExcludingSlot( pSoldier, pObj->usGunAmmoItem, bExcludeSlot );
			if (bSlot != NO_SLOT)
				// reload using this ammo!
				return( bSlot );
		}
		// look for any ammo that matches which is of the same calibre and magazine size
		bSlot = FindAmmo( pSoldier, Weapon[ Item[pObj->usItem].ubClassIndex].ubCalibre, Weapon[ Item[pObj->usItem].ubClassIndex].ubFeedType, bExcludeSlot );
		if (bSlot != NO_SLOT)
		{
			return( bSlot );
		}
		else
		{
			// look for any ammo that matches which is of the same calibre (different size okay)
			return( FindAmmo( pSoldier, Weapon[ Item[pObj->usItem].ubClassIndex].ubCalibre, ANY_MAGSIZE, bExcludeSlot ) );
		}
	}
	else
	{
		switch( pObj->usItem )
		{
			case MORTAR:
				return( FindObj( pSoldier, MORTAR_SHELL ) );
			case TANK_CANNON:
				return( FindObj( pSoldier, TANK_SHELL ) );
			case GLAUNCHER:
			case UNDER_GLAUNCHER:
				return( FindObjInObjRange( pSoldier, GL_HE_GRENADE, GL_SMOKE_GRENADE ) );
			default:
				return( NO_SLOT );
		}
	}
}

BOOLEAN AutoReload( SOLDIERTYPE * pSoldier )
{
	OBJECTTYPE *	pObj;
	INT8					bSlot, bAPCost;
	BOOLEAN				fRet;
	LPTSTR tsSound;

	CHECKF( pSoldier );
	pObj = &(pSoldier->inv[HANDPOS]);

//<SB> manual recharge
	if (pObj->ubGunShotsLeft && !(pObj->ubGunState & GS_CARTRIDGE_IN_CHAMBER) )
	{
		pObj->ubGunState |= GS_CARTRIDGE_IN_CHAMBER;
		DeductPoints(pSoldier,RECHARGE_APS(pObj),0);
		tsSound = Weapon[ Item[pObj->usItem].ubClassIndex ].tsLocknLoadSound;
		if ( *tsSound )
			SBStrPlayJA2Sample( tsSound, RATE_11025, SoundVolume( HIGHVOLUME, pSoldier->sGridNo ), 1, SoundDir( pSoldier->sGridNo ) );
		return TRUE;
	}
//</SB>

	if (Item[pObj->usItem].usItemClass == IC_GUN || Item[pObj->usItem].usItemClass == IC_LAUNCHER)
	{
		bSlot = FindAmmoToReload( pSoldier, HANDPOS, NO_SLOT );
		if (bSlot != NO_SLOT)
		{
			// reload using this ammo!
			fRet = ReloadGun( pSoldier, pObj, &(pSoldier->inv[bSlot]) );
			// if we are valid for two-pistol shooting (reloading) and we have enough APs still
			// then do a reload of both guns!
			if ( (fRet == TRUE) && IsValidSecondHandShotForReloadingPurposes( pSoldier ) )
			{
				pObj = &(pSoldier->inv[SECONDHANDPOS]);
				bSlot = FindAmmoToReload( pSoldier, SECONDHANDPOS, NO_SLOT );
				if (bSlot != NO_SLOT)
				{
					// ce would reload using this ammo!
					bAPCost = GetAPsToReloadGunWithAmmo( pObj, &(pSoldier->inv[bSlot] ) );
					if ( EnoughPoints( pSoldier, (INT16) bAPCost, 0, FALSE ) )
					{
						// reload the 2nd gun too
						fRet = ReloadGun( pSoldier, pObj, &(pSoldier->inv[bSlot]) );
					}
					else
					{						
						ScreenMsg( FONT_MCOLOR_LTYELLOW, MSG_INTERFACE, Message[ STR_RELOAD_ONLY_ONE_GUN ], pSoldier->name );
					}
				}
			}

			DirtyMercPanelInterface( pSoldier, DIRTYLEVEL2 );
			return( fRet );
		}
	}

	// couldn't reload
	return( FALSE );
}

INT8 GetAttachmentComboMerge( OBJECTTYPE * pObj )
{
	INT8		bIndex = 0;
	INT8		bAttachLoop, bAttachPos;

	while( AttachmentComboMerge[ bIndex ].usItem != NOTHING )
	{
		if ( pObj->usItem == AttachmentComboMerge[ bIndex ].usItem )
		{
			// search for all the appropriate attachments 
			for ( bAttachLoop = 0; bAttachLoop < 2; bAttachLoop++ )
			{
				if ( AttachmentComboMerge[ bIndex ].usAttachment[ bAttachLoop ] == NOTHING )
				{
					continue;
				}

				bAttachPos = FindAttachment( pObj, AttachmentComboMerge[ bIndex ].usAttachment[ bAttachLoop ] );
				if ( bAttachPos == -1 )
				{
					// didn't find something required
					return( -1 );
				}
			}
			// found everything required!
			return( bIndex );
		}

		bIndex++;
	}

	return( -1 );
}

void PerformAttachmentComboMerge( OBJECTTYPE * pObj, INT8 bAttachmentComboMerge )
{
	INT8		bAttachLoop, bAttachPos;
	UINT32	uiStatusTotal = 0;
	INT8		bNumStatusContributors = 0;

	// This object has been validated as available for an attachment combo merge.
	// - find all attachments in list and destroy them
	// - status of new object should be average of items including attachments
	// - change object

	for ( bAttachLoop = 0; bAttachLoop < 2; bAttachLoop++ )
	{
		if ( AttachmentComboMerge[ bAttachmentComboMerge ].usAttachment[ bAttachLoop ] == NOTHING )
		{
			continue;
		}

		bAttachPos = FindAttachment( pObj, AttachmentComboMerge[ bAttachmentComboMerge ].usAttachment[ bAttachLoop ] );
		AssertMsg( bAttachPos != -1, String( "Attachment combo merge couldn't find a necessary attachment" ) );
		
		uiStatusTotal += pObj->bAttachStatus[ bAttachPos ];
		bNumStatusContributors++;
//SB for detachable tripod
//		pObj->usAttachItem[ bAttachPos ] = NOTHING;
//		pObj->bAttachStatus[ bAttachPos ] = 0;

	}

	uiStatusTotal += pObj->bStatus[ 0 ];
	bNumStatusContributors++;

	pObj->usItem = AttachmentComboMerge[ bAttachmentComboMerge ].usResult;
	pObj->bStatus[ 0 ] = (INT8) (uiStatusTotal / bNumStatusContributors );
}

BOOLEAN AttachObject( SOLDIERTYPE * pSoldier, OBJECTTYPE * pTargetObj, OBJECTTYPE * pAttachment )
{
	INT8		bAttachPos, bSecondAttachPos;//, bAbility, bSuccess;
	UINT16	usResult;
	INT8		bLoop;
	UINT8		ubType, ubLimit;
	INT32		iCheckResult;
	INT8		bAttachInfoIndex = -1, bAttachComboMerge;
	BOOLEAN	fValidLaunchable = FALSE;

	fValidLaunchable = ValidLaunchable( pAttachment->usItem, pTargetObj->usItem );

	if ( fValidLaunchable || ValidItemAttachment( pTargetObj, pAttachment->usItem, TRUE ) )
	{
		OBJECTTYPE	TempObj = {0};

		// find an attachment position... 
		// second half of this 'if' is for attaching GL grenades to a gun
		if ( fValidLaunchable || pAttachment->usItem >= GL_HE_GRENADE && pAttachment->usItem <= GL_SMOKE_GRENADE )
		{
			// try replacing if possible
			bAttachPos = FindAttachmentByClass( pTargetObj, Item[ pAttachment->usItem ].usItemClass );
			if ( bAttachPos != NO_SLOT )
			{
				// we can only do a swap if there is only 1 grenade being attached
				if ( pAttachment->ubNumberOfObjects > 1 )
				{
					return( FALSE );
				}
			}
			else
			{
				bAttachPos = FindAttachment( pTargetObj, NOTHING );
			}
		}
		else
		{
			// try replacing if possible
			bAttachPos = FindAttachment( pTargetObj, pAttachment->usItem );
			if ( bAttachPos == NO_SLOT )
			{
				bAttachPos = FindAttachment( pTargetObj, NOTHING );
			}
		}

		if (bAttachPos == ITEM_NOT_FOUND)
		{
			return( FALSE );
		}
		else
		{
			if ( pSoldier )
			{
				bAttachInfoIndex = GetAttachmentInfoIndex( pAttachment->usItem );
				// in-game (not behind the scenes) attachment
				if ( bAttachInfoIndex != -1 && AttachmentInfo[ bAttachInfoIndex ].bAttachmentSkillCheck != NO_CHECK )
				{
					iCheckResult = SkillCheck( pSoldier, AttachmentInfo[ bAttachInfoIndex ].bAttachmentSkillCheck, AttachmentInfo[ bAttachInfoIndex ].bAttachmentSkillCheckMod );
					if (iCheckResult < 0)		
					{
						// the attach failure damages both items
						DamageObj( pTargetObj, (INT8) -iCheckResult );
						DamageObj( pAttachment, (INT8) -iCheckResult );
						// there should be a quote here!
						DoMercBattleSound( pSoldier, BATTLE_SOUND_CURSE1 );
						if ( gfInItemDescBox )
						{
							DeleteItemDescriptionBox();
						}
						return( FALSE );
					}
				}

				if ( ValidItemAttachment( pTargetObj, pAttachment->usItem, TRUE ) ) // not launchable
				{
					// attachment sounds
					if ( Item[ pTargetObj->usItem ].usItemClass & IC_WEAPON )
					{
						PlayJA2Sample( ATTACH_TO_GUN, RATE_11025, SoundVolume( MIDVOLUME, pSoldier->sGridNo ), 1, SoundDir( pSoldier->sGridNo ) );
					}
					else if ( Item[ pTargetObj->usItem ].usItemClass & IC_ARMOUR )
					{
						PlayJA2Sample( ATTACH_CERAMIC_PLATES, RATE_11025, SoundVolume( MIDVOLUME, pSoldier->sGridNo ), 1, SoundDir( pSoldier->sGridNo ) );
					}
					else if ( Item[ pTargetObj->usItem ].usItemClass & IC_BOMB )
					{
						PlayJA2Sample( ATTACH_DETONATOR, RATE_11025, SoundVolume( MIDVOLUME, pSoldier->sGridNo ), 1, SoundDir( pSoldier->sGridNo ) );
					}
				}
			}

			if ( pTargetObj->usAttachItem[ bAttachPos ] != NOTHING )
			{
				CreateItem( pTargetObj->usAttachItem[bAttachPos], pTargetObj->bAttachStatus[bAttachPos], &TempObj );
			}

			pTargetObj->usAttachItem[bAttachPos] = pAttachment->usItem;
			pTargetObj->bAttachStatus[bAttachPos] = pAttachment->bStatus[0];

			if (pAttachment->usItem == UNDER_GLAUNCHER)
			{
				// transfer any attachment (max 1) from the grenade launcher to the gun
				if (pAttachment->usAttachItem[0] != NOTHING)
				{
					bSecondAttachPos = FindAttachment( pTargetObj, NOTHING );
					if (bSecondAttachPos == ITEM_NOT_FOUND)
					{
						// not enough room for all attachments - cancel!!
						pTargetObj->usAttachItem[bAttachPos] = NOTHING;
						pTargetObj->bAttachStatus[bAttachPos] = 0;
						return( FALSE );
					}
					else
					{
						pTargetObj->usAttachItem[bSecondAttachPos] = pAttachment->usAttachItem[0];
						pTargetObj->bAttachStatus[bSecondAttachPos] = pAttachment->bAttachStatus[0];
						pAttachment->usAttachItem[0] = NOTHING;
						pAttachment->bAttachStatus[0] = 0;
					}
				}
			}

			if ( TempObj.usItem != NOTHING )
			{
				// overwrite/swap!
				CopyObj( &TempObj, pAttachment );
			}
			else
			{
				RemoveObjs( pAttachment, 1 );
			}

			// Check for attachment merge combos here
			bAttachComboMerge = GetAttachmentComboMerge( pTargetObj );
			if ( bAttachComboMerge != -1 )
			{
				PerformAttachmentComboMerge( pTargetObj, bAttachComboMerge );
				if ( bAttachInfoIndex != -1 && AttachmentInfo[ bAttachInfoIndex ].bAttachmentSkillCheckMod < 20 )
				{
					StatChange( pSoldier, MECHANAMT, (INT8) ( 20 - AttachmentInfo[ bAttachInfoIndex ].bAttachmentSkillCheckMod ), FALSE );
				}
			}

			pTargetObj->ubWeight = CalculateObjectWeight( pTargetObj );

			return( TRUE );
		}
	}
	// check for merges
	else if (EvaluateValidMerge( pAttachment->usItem, pTargetObj->usItem, &usResult, &ubType, pTargetObj ))	
	{
		if ( ubType != COMBINE_POINTS )
		{
			if ( !EnoughPoints( pSoldier, AP_MERGE, 0, TRUE ) )
			{
				return( FALSE );
			}

			DeductPoints( pSoldier, AP_MERGE, 0 );
		}

		switch( ubType )
		{
			case COMBINE_POINTS:
				pTargetObj->usItem = usResult;
				// transfer points...
				if ( Item[ pTargetObj->usItem ].usItemClass == IC_AMMO )
				{
					ubLimit = Magazine[ Item[ pTargetObj->usItem ].ubClassIndex ].ubMagSize;
				}
				else
				{
					ubLimit = 100;
				}

				// count down through # of attaching items and add to status of item in position 0
				for (bLoop = pAttachment->ubNumberOfObjects - 1; bLoop >= 0; bLoop--)
				{
					if (pTargetObj->bStatus[0] + pAttachment->bStatus[bLoop] <= ubLimit)
					{
						// consume this one totally and continue
						pTargetObj->bStatus[0] += pAttachment->bStatus[bLoop];
//<SB> erase ammo only if it ammo box
						if( Magazine[Item[pAttachment->usItem].ubClassIndex].ubFeedType == 255 )
						{
							RemoveObjFrom( pAttachment, bLoop );
							// reset loop limit
							bLoop = pAttachment->ubNumberOfObjects; // add 1 to counteract the -1 from the loop
						}
						else
							pAttachment->bStatus[bLoop] = 0;
//</SB>
					}
					else
					{
						// add part of this one and then we're done
						pAttachment->bStatus[bLoop] -= (ubLimit - pTargetObj->bStatus[0]);
						pTargetObj->bStatus[0] = ubLimit;
						break;
					}
				}
				break;
			case DESTRUCTION:
				// the merge destroyed both items!
				DeleteObj( pTargetObj );
				DeleteObj( pAttachment );
				DoMercBattleSound( pSoldier, BATTLE_SOUND_CURSE1 );
				break;
			case ELECTRONIC_MERGE:
				if ( pSoldier ) 
				{
					iCheckResult = SkillCheck( pSoldier, ATTACHING_SPECIAL_ELECTRONIC_ITEM_CHECK, -30 );
					if ( iCheckResult < 0 )
					{
						DamageObj( pTargetObj, (INT8) -iCheckResult );
						DamageObj( pAttachment, (INT8) -iCheckResult );
						DoMercBattleSound( pSoldier, BATTLE_SOUND_CURSE1 );
						return( FALSE );
					}
					// grant experience!
				}
				// fall through
			case EXPLOSIVE:
				if ( ubType == EXPLOSIVE ) /// coulda fallen through
				{
					if (pSoldier)
					{
						// requires a skill check, and gives experience 				
						iCheckResult = SkillCheck( pSoldier, ATTACHING_DETONATOR_CHECK, -30 );
						if (iCheckResult < 0)
						{
							// could have a chance of detonation
							// for now, damage both objects
							DamageObj( pTargetObj, (INT8) -iCheckResult );
							DamageObj( pAttachment, (INT8) -iCheckResult );
							DoMercBattleSound( pSoldier, BATTLE_SOUND_CURSE1 );
							return( FALSE );
						}				
						StatChange( pSoldier, EXPLODEAMT, 25, FALSE );
					}
				}
				// fall through
			default:
				// the merge will combine the two items
				pTargetObj->usItem = usResult;
				if ( ubType != TREAT_ARMOUR )
				{
					pTargetObj->bStatus[0] = (pTargetObj->bStatus[0] + pAttachment->bStatus[0]) / 2;
				}
				DeleteObj( pAttachment );
				pTargetObj->ubWeight = CalculateObjectWeight( pTargetObj );
				if (pSoldier && pSoldier->bTeam == gbPlayerNum)
				{
					DoMercBattleSound( pSoldier, BATTLE_SOUND_COOL1 );
				}
				break;
			}
			return( TRUE );
	}
	return( FALSE );
}


BOOLEAN CanItemFitInPosition( SOLDIERTYPE *pSoldier, OBJECTTYPE *pObj, INT8 bPos, BOOLEAN fDoingPlacement )
{
	UINT8					ubSlotLimit;
	INT8					bNewPos;

	if(Item[pObj->usItem].fFlags & ITEM_IS_VERY_BIG)
		if( bPos == HANDPOS)
			return TRUE;
		else
			return FALSE;

	switch( bPos )
	{
		case SECONDHANDPOS:
			if (Item[pSoldier->inv[HANDPOS].usItem].fFlags & ITEM_TWO_HANDED)
			{
				return( FALSE );
			}
			break;
		case HANDPOS:
			if (Item[ pObj->usItem ].fFlags & ITEM_TWO_HANDED)
			{
				if (pSoldier->inv[HANDPOS].usItem != NOTHING && pSoldier->inv[SECONDHANDPOS].usItem != NOTHING)
				{
					// two items in hands; try moving the second one so we can swap 
					if (Item[pSoldier->inv[SECONDHANDPOS].usItem].ubPerPocket == 0)
					{
						bNewPos = FindEmptySlotWithin( pSoldier, BIGPOCK1POS, BIGPOCK4POS );
					}
					else
					{
						bNewPos = FindEmptySlotWithin( pSoldier, BIGPOCK1POS, SMALLPOCK8POS );
					}
					if (bNewPos == NO_SLOT)
					{
						// nowhere to put second item
						return( FALSE );
					}

					if ( fDoingPlacement )
					{
						// otherwise move it.
						CopyObj( &(pSoldier->inv[SECONDHANDPOS]), &(pSoldier->inv[bNewPos]) );
						DeleteObj( &(pSoldier->inv[SECONDHANDPOS]) );
					}
				}
			}
			break;
		case VESTPOS:
		case HELMETPOS:
		case LEGPOS:
			if (Item[pObj->usItem].usItemClass != IC_ARMOUR)
			{
				return( FALSE );
			}
			switch (bPos)
			{
				case VESTPOS:
					if (Armour[Item[pObj->usItem].ubClassIndex].ubArmourClass != ARMOURCLASS_VEST)
					{
						return( FALSE );
					}		
					break;
				case HELMETPOS:
					if (Armour[Item[pObj->usItem].ubClassIndex].ubArmourClass != ARMOURCLASS_HELMET)
					{
						return( FALSE );
					}		
					break;
				case LEGPOS:
					if (Armour[Item[pObj->usItem].ubClassIndex].ubArmourClass != ARMOURCLASS_LEGGINGS)
					{
						return( FALSE );
					}		
					break;
				default:
					break;
			}
			break;
		case HEAD1POS:
		case HEAD2POS:
			if (Item[pObj->usItem].usItemClass != IC_FACE)
			{
				return( FALSE );
			}
		default:
			break;
	}

	ubSlotLimit = ItemSlotLimit( pObj->usItem, bPos );
	if (ubSlotLimit == 0 && bPos >= SMALLPOCK1POS )
	{
		// doesn't fit!
		return( FALSE );
	}

	return( TRUE );
}


BOOLEAN DropObjIfThereIsRoom( SOLDIERTYPE * pSoldier, INT8 bPos, OBJECTTYPE * pObj )
{
	// try autoplacing item in bSlot elsewhere, then do a placement
	BOOLEAN fAutoPlacedOld;

	fAutoPlacedOld = AutoPlaceObject( pSoldier, &(pSoldier->inv[bPos]), FALSE );
	if ( fAutoPlacedOld )
	{
		return( PlaceObject( pSoldier, bPos, pObj ) );
	}
	else
	{
		return( FALSE );
	}
}


BOOLEAN PlaceObject( SOLDIERTYPE * pSoldier, INT8 bPos, OBJECTTYPE * pObj )
{
	// returns object to have in hand after placement... same as original in the
	// case of error

	UINT8					ubSlotLimit, ubNumberToDrop, ubLoop;
	OBJECTTYPE *	pInSlot;
	BOOLEAN				fObjectWasRobotRemote = FALSE;

	if ( pObj->usItem == ROBOT_REMOTE_CONTROL )
	{
		fObjectWasRobotRemote = TRUE;
	}

	if ( !CanItemFitInPosition( pSoldier, pObj, bPos, TRUE ) )
	{
		return( FALSE );
	}

	// If the position is either head slot, then the item must be IC_FACE (checked in
	// CanItemFitInPosition).
	if ( bPos == HEAD1POS )
	{
		if ( !CompatibleFaceItem( pObj->usItem, pSoldier->inv[ HEAD2POS ].usItem ) )
		{
			UINT16	zTemp[ 150 ];

			swprintf( zTemp, Message[ STR_CANT_USE_TWO_ITEMS ], ItemNames[ pObj->usItem ], ItemNames[ pSoldier->inv[ HEAD2POS ].usItem ] );
			ScreenMsg( FONT_MCOLOR_LTYELLOW, MSG_UI_FEEDBACK, zTemp );
			return( FALSE );
		}
	}
	else if ( bPos == HEAD2POS )
	{
		if ( !CompatibleFaceItem( pObj->usItem, pSoldier->inv[ HEAD1POS ].usItem ) )
		{
			UINT16	zTemp[ 150 ];

			swprintf( zTemp, Message[ STR_CANT_USE_TWO_ITEMS ], ItemNames[ pObj->usItem ], ItemNames[ pSoldier->inv[ HEAD1POS ].usItem ] );
			ScreenMsg( FONT_MCOLOR_LTYELLOW, MSG_UI_FEEDBACK, zTemp );
			return( FALSE );
		}
	}

	if ( Item[ pObj->usItem ].usItemClass == IC_KEY && pSoldier->uiStatusFlags & SOLDIER_PC )
	{
		if ( KeyTable[ pObj->ubKeyID ].usDateFound == 0 )
		{
			KeyTable[ pObj->ubKeyID ].usDateFound = (UINT16) GetWorldDay();
			KeyTable[ pObj->ubKeyID ].usSectorFound = SECTOR( pSoldier->sSectorX, pSoldier->sSectorY );
		}
	}

	ubSlotLimit = ItemSlotLimit( pObj->usItem, bPos );

	pInSlot = &(pSoldier->inv[bPos]);

	if (pInSlot->ubNumberOfObjects == 0)
	{
		// placement in an empty slot
		ubNumberToDrop = pObj->ubNumberOfObjects;

		if (ubNumberToDrop > __max( ubSlotLimit, 1 ) )
		{
			// drop as many as possible into pocket
			ubNumberToDrop = __max( ubSlotLimit, 1 );
		}

		// could be wrong type of object for slot... need to check...
		// but assuming it isn't
		memcpy( pInSlot, pObj, sizeof( OBJECTTYPE ) );
/*
		//if we are in the shopkeeper interface
		if( guiTacticalInterfaceFlags & INTERFACE_SHOPKEEP_INTERFACE )
		{
			memset( &gMoveingItem, 0, sizeof( INVENTORY_IN_SLOT ) );
			SetSkiCursor( CURSOR_NORMAL );
		}
*/

		if (ubNumberToDrop != pObj->ubNumberOfObjects)
		{
			// in the InSlot copy, zero out all the objects we didn't drop
			for (ubLoop = ubNumberToDrop; ubLoop < pObj->ubNumberOfObjects; ubLoop++)
			{
				pInSlot->bStatus[ubLoop] = 0;
			}
		}
		pInSlot->ubNumberOfObjects = ubNumberToDrop;

		// remove a like number of objects from pObj
		RemoveObjs( pObj, ubNumberToDrop );
		if (pObj->ubNumberOfObjects == 0)
		{
			// dropped everything
			if (bPos == HANDPOS && Item[pInSlot->usItem].fFlags & ITEM_TWO_HANDED)
			{
				// We just performed a successful drop of a two-handed object into the
				// main hand
				if (pSoldier->inv[SECONDHANDPOS].usItem != 0)
				{
					// swap what WAS in the second hand into the cursor
					SwapObjs( pObj, &(pSoldier->inv[SECONDHANDPOS]));
				}
			}
		}
	}
	else
	{
		// replacement/reloading/merging/stacking	
		// keys have an additional check for key ID being the same
		if ( (pObj->usItem == pInSlot->usItem) && ( Item[ pObj->usItem ].usItemClass != IC_KEY || pObj->ubKeyID == pInSlot->ubKeyID ) )
		{
			if (Item[ pObj->usItem ].usItemClass == IC_MONEY)
			{
	
				UINT32 uiMoneyMax = MoneySlotLimit( bPos );

				// always allow money to be combined!
				// IGNORE STATUS!

				if (pInSlot->uiMoneyAmount + pObj->uiMoneyAmount > uiMoneyMax)
				{
					// remove X dollars
					pObj->uiMoneyAmount -= (uiMoneyMax - pInSlot->uiMoneyAmount);
					// set in slot to maximum
					pInSlot->uiMoneyAmount = uiMoneyMax;
				}
				else
				{
					pInSlot->uiMoneyAmount += pObj->uiMoneyAmount;
					DeleteObj( pObj );
/*
					if( guiTacticalInterfaceFlags & INTERFACE_SHOPKEEP_INTERFACE )
					{
						memset( &gMoveingItem, 0, sizeof( INVENTORY_IN_SLOT ) );
						SetSkiCursor( CURSOR_NORMAL );
					}
*/
				}
			}
			else if ( ubSlotLimit == 1 || (ubSlotLimit == 0 && bPos >= HANDPOS && bPos <= BIGPOCK4POS ) )
			{
				if (pObj->ubNumberOfObjects <= 1)
				{
					// swapping
					SwapObjs( pObj, pInSlot );
				}
				else
				{
					return( DropObjIfThereIsRoom( pSoldier, bPos, pObj ) );
				}
			}
			else if (ubSlotLimit == 0) // trying to drop into a small pocket
			{
				return( DropObjIfThereIsRoom( pSoldier, bPos, pObj ) );
			}
			else
			{
				// stacking
				ubNumberToDrop = ubSlotLimit - pInSlot->ubNumberOfObjects;
				if (ubNumberToDrop > pObj->ubNumberOfObjects)
				{
					ubNumberToDrop = pObj->ubNumberOfObjects;
				}
				StackObjs( pObj, pInSlot, ubNumberToDrop );
			}
		}
		else
		{
			// replacement, unless reloading...	
			switch (Item[pInSlot->usItem].usItemClass)
			{
				case IC_GUN:
					if (Item[pObj->usItem].usItemClass == IC_AMMO)
					{
						if (Weapon[ Item[pInSlot->usItem].ubClassIndex].ubCalibre == Magazine[Item[pObj->usItem].ubClassIndex].ubCalibre)
						{
							// reload... 
							return( ReloadGun( pSoldier, pInSlot, pObj ) );
						}
						else
						{
							// invalid ammo
							break;
							//return( FALSE );
						}
					}
					break;
				case IC_LAUNCHER:
				{			
					if ( ValidLaunchable( pObj->usItem, pInSlot->usItem ) )
					{
						// reload... 						
						return( ReloadGun( pSoldier, pInSlot, pObj ) );
					}
				}
				break;
			}

			if ( (Item[pObj->usItem].fFlags & ITEM_TWO_HANDED) && (bPos == HANDPOS) )
			{
				if (pSoldier->inv[SECONDHANDPOS].usItem != 0)
				{
					// both pockets have something in them, so we can't swap
					return( FALSE );
				}
				else
				{
					SwapObjs( pObj, pInSlot );	
				}
			}
			else if (pObj->ubNumberOfObjects <= __max( ubSlotLimit, 1 ) )
			{
				// swapping
				SwapObjs( pObj, pInSlot );
			}
			else
			{
				return( DropObjIfThereIsRoom( pSoldier, bPos, pObj ) );
			}

		}
	}

	// ATE: Put this in to see if we should update the robot, if we were given a controller...
	if ( pSoldier->bTeam == gbPlayerNum && fObjectWasRobotRemote )
	{
		UpdateRobotControllerGivenController( pSoldier );
	}

	return( TRUE );
}

BOOLEAN InternalAutoPlaceObject( SOLDIERTYPE * pSoldier, OBJECTTYPE * pObj, BOOLEAN fNewItem, INT8 bExcludeSlot )
{
	INT8			bSlot;
	INVTYPE	* pItem;
	UINT8			ubPerSlot;

	// statuses of extra objects would be 0 if the # exceeds the maximum
	Assert( pObj->ubNumberOfObjects <= MAX_OBJECTS_PER_SLOT);

	pItem = &(Item[pObj->usItem]);
	ubPerSlot = pItem->ubPerPocket;

//<SB> handle very big item which fits only in main hand
	if(pItem->fFlags & ITEM_IS_VERY_BIG)
		if (pSoldier->inv[HANDPOS].usItem == NONE)
		{
			// put the one-handed weapon in the guy's hand...
			PlaceObject( pSoldier, HANDPOS, pObj );
			SetNewItem( pSoldier, HANDPOS, fNewItem );
			return TRUE;
		}
		else
			return FALSE;
//</SB>
	// Overrides to the standard system: put guns in hand, armour on body (if slot empty)
	switch (pItem->usItemClass)
	{
		case IC_GUN:
		case IC_BLADE:
		case IC_LAUNCHER:
		case IC_BOMB:
		case IC_GRENADE:
			if (!(pItem->fFlags & ITEM_TWO_HANDED))
			{
				if (pSoldier->inv[HANDPOS].usItem == NONE)
				{
					// put the one-handed weapon in the guy's hand...
					PlaceObject( pSoldier, HANDPOS, pObj );
					SetNewItem( pSoldier, HANDPOS, fNewItem );
					if ( pObj->ubNumberOfObjects == 0 )
					{
						return( TRUE );
					}
				}
				else if ( !(Item[pSoldier->inv[HANDPOS].usItem].fFlags & ITEM_TWO_HANDED) && pSoldier->inv[SECONDHANDPOS].usItem == NONE)
				{
					// put the one-handed weapon in the guy's 2nd hand...
					PlaceObject( pSoldier, SECONDHANDPOS, pObj );
					SetNewItem( pSoldier, SECONDHANDPOS, fNewItem );
					if ( pObj->ubNumberOfObjects == 0 )
					{
						return( TRUE );
					}
				}
			}
			// two-handed objects are best handled in the main loop for large objects,
			// which checks the hands first anyhow			
			break;

		case IC_ARMOUR:
			switch (Armour[Item[pObj->usItem].ubClassIndex].ubArmourClass)
			{
				case ARMOURCLASS_VEST:
					if (pSoldier->inv[VESTPOS].usItem == NONE)
					{
						// put on the armour!
						PlaceObject( pSoldier, VESTPOS, pObj );
						SetNewItem( pSoldier, VESTPOS, fNewItem );
						if ( pObj->ubNumberOfObjects == 0 )
						{
							return( TRUE );
						}
					}
					break;
				case ARMOURCLASS_LEGGINGS:
					if (pSoldier->inv[LEGPOS].usItem == NONE)
					{
						// put on the armour!
						PlaceObject( pSoldier, LEGPOS, pObj );
						SetNewItem( pSoldier, LEGPOS, fNewItem );
						if ( pObj->ubNumberOfObjects == 0 )
						{
							return( TRUE );
						}
					}
					break;
				case ARMOURCLASS_HELMET:
					if (pSoldier->inv[HELMETPOS].usItem == NONE)
					{
						// put on the armour!
						PlaceObject( pSoldier, HELMETPOS, pObj );
						SetNewItem( pSoldier, HELMETPOS, fNewItem );
						if ( pObj->ubNumberOfObjects == 0 )
						{
							return( TRUE );
						}
					}
					break;
				default:
					break;
			}
			// otherwise stuff it in a slot somewhere
			break;
		case IC_FACE:
			if ( (pSoldier->inv[HEAD1POS].usItem == NOTHING) && CompatibleFaceItem( pObj->usItem, pSoldier->inv[HEAD2POS].usItem ) )
			{
				PlaceObject( pSoldier, HEAD1POS, pObj );
				SetNewItem( pSoldier, HEAD1POS, fNewItem );
				if ( pObj->ubNumberOfObjects == 0 )
				{
					return( TRUE );
				}
			}
			else if ( (pSoldier->inv[HEAD2POS].usItem == NOTHING) && CompatibleFaceItem( pObj->usItem, pSoldier->inv[HEAD1POS].usItem ) )
			{
				PlaceObject( pSoldier, HEAD2POS, pObj );
				SetNewItem( pSoldier, HEAD2POS, fNewItem );
				if ( pObj->ubNumberOfObjects == 0 )
				{
					return( TRUE );
				}
			}
			break;
		default:
			break;
	}

	if (ubPerSlot == 0)
	{
		// Large object; look for an empty hand/large pocket and dump it in there
		// FindObjWithin with 0 will search for empty slots!
		bSlot = HANDPOS;
		while (1) 
		{	
			bSlot = FindEmptySlotWithin( pSoldier, bSlot, BIGPOCK4POS );
			if (bSlot == ITEM_NOT_FOUND)
			{
				return( FALSE );
			}
			if (bSlot == SECONDHANDPOS)
			{
				if (pSoldier->inv[HANDPOS].usItem != NONE)
				{
					bSlot++;
					continue;
				}
			}
			// this might fail if we're trying to place in HANDPOS,
			// and SECONDHANDPOS is full
			PlaceObject( pSoldier, bSlot, pObj );
			SetNewItem( pSoldier, bSlot, fNewItem );
			if (pObj->ubNumberOfObjects == 0)
			{
				return( TRUE );
			}
			bSlot++;
		} 
	}
	else
	{
		// Small items; don't allow stack/dumping for keys right now as that
		// would require a bunch of functions for finding the same object by two values...
		if ( ubPerSlot > 1 || Item[ pObj->usItem ].usItemClass == IC_KEY || Item[ pObj->usItem ].usItemClass == IC_MONEY )
		{
			// First, look for slots with the same object, and dump into them.
			bSlot = HANDPOS;
			while( 1 )
			{
				bSlot = FindObjWithin( pSoldier, pObj->usItem, bSlot, SMALLPOCK8POS );
				if (bSlot == ITEM_NOT_FOUND)
				{
					break;
				}
				if ( bSlot != bExcludeSlot )
				{
					if ( ( (Item[ pObj->usItem ].usItemClass == IC_MONEY) && pSoldier->inv[ bSlot ].uiMoneyAmount < MoneySlotLimit( bSlot ) ) || (Item[ pObj->usItem ].usItemClass != IC_MONEY && pSoldier->inv[bSlot].ubNumberOfObjects < ItemSlotLimit( pObj->usItem, bSlot ) ) )
					{
						// NEW: If in SKI, don't auto-place anything into a stackable slot that's currently hatched out!  Such slots
						// will disappear in their entirety if sold/moved, causing anything added through here to vanish also!
						if( !( ( guiTacticalInterfaceFlags & INTERFACE_SHOPKEEP_INTERFACE ) && ShouldSoldierDisplayHatchOnItem( pSoldier->ubProfile, bSlot ) ) )
						{
							PlaceObject( pSoldier, bSlot, pObj );
							SetNewItem( pSoldier, bSlot, fNewItem );
							if (pObj->ubNumberOfObjects == 0)
							{
								return( TRUE );
							}
						}
					}
				}
				bSlot++;
			}
		}
		// Search for empty slots to dump into, starting with small pockets
		bSlot = SMALLPOCK1POS;
		while( 1 )
		{
			bSlot = FindEmptySlotWithin( pSoldier, bSlot, SMALLPOCK8POS );
			if (bSlot == ITEM_NOT_FOUND)
			{
				break;
			}
			PlaceObject( pSoldier, bSlot, pObj );
			SetNewItem( pSoldier, bSlot, fNewItem );
			if (pObj->ubNumberOfObjects == 0)
			{
				return( TRUE );
			}
			bSlot++;
		}
		// now check hands/large pockets
		bSlot = HANDPOS;
		while (1)		
		{
			bSlot = FindEmptySlotWithin( pSoldier, bSlot, BIGPOCK4POS );
			if (bSlot == ITEM_NOT_FOUND)
			{
				break;
			}
			PlaceObject( pSoldier, bSlot, pObj );
			SetNewItem( pSoldier, bSlot, fNewItem );
			if (pObj->ubNumberOfObjects == 0)
			{
				return( TRUE );
			}
			bSlot++;
		}
	}
	return( FALSE );
}

BOOLEAN AutoPlaceObject( SOLDIERTYPE * pSoldier, OBJECTTYPE * pObj, BOOLEAN fNewItem )
{
	return( InternalAutoPlaceObject( pSoldier, pObj, fNewItem, NO_SLOT ) );
}

BOOLEAN RemoveObjectFromSlot( SOLDIERTYPE * pSoldier, INT8 bPos, OBJECTTYPE * pObj )
{
	CHECKF( pObj );
	if (pSoldier->inv[bPos].ubNumberOfObjects == 0)
	{
		return( FALSE );
	}
	else
	{
		memcpy( pObj, &(pSoldier->inv[bPos]), sizeof( OBJECTTYPE ) );
		DeleteObj( &(pSoldier->inv[bPos]) );
		return( TRUE );
	}
}

BOOLEAN RemoveKeyFromSlot( SOLDIERTYPE * pSoldier, INT8 bKeyRingPosition, OBJECTTYPE * pObj )
{
	UINT8 ubItem = 0;

	CHECKF( pObj );
	
	if( ( pSoldier->pKeyRing[ bKeyRingPosition ].ubNumber == 0 ) || ( pSoldier->pKeyRing[ bKeyRingPosition ].ubKeyID == INVALID_KEY_NUMBER ) )
	{
		return( FALSE );
	}
	else
	{
		//memcpy( pObj, &(pSoldier->inv[bPos]), sizeof( OBJECTTYPE ) );
		
		// create an object
		ubItem = pSoldier->pKeyRing[ bKeyRingPosition ].ubKeyID;

		if( pSoldier->pKeyRing[ bKeyRingPosition ].ubNumber > 1 )
		{
			pSoldier->pKeyRing[ bKeyRingPosition ].ubNumber--;
		}
		else
		{
			
			pSoldier->pKeyRing[ bKeyRingPosition ].ubNumber = 0;
			pSoldier->pKeyRing[ bKeyRingPosition ].ubKeyID = INVALID_KEY_NUMBER;
		}

		return( CreateKeyObject( pObj, 1, ubItem ) );
	}

	return( FALSE );
}


BOOLEAN RemoveKeysFromSlot( SOLDIERTYPE * pSoldier, INT8 bKeyRingPosition, UINT8 ubNumberOfKeys ,OBJECTTYPE * pObj )
{
	UINT8 ubItems = 0;

	CHECKF( pObj );
	

	if( ( pSoldier->pKeyRing[ bKeyRingPosition ].ubNumber == 0 ) || ( pSoldier->pKeyRing[ bKeyRingPosition ].ubKeyID == INVALID_KEY_NUMBER ) )
	{
		return( FALSE );
	}
	else
	{
		//memcpy( pObj, &(pSoldier->inv[bPos]), sizeof( OBJECTTYPE ) );
		
		if( pSoldier->pKeyRing[ bKeyRingPosition ].ubNumber < ubNumberOfKeys )
		{
			ubNumberOfKeys = pSoldier->pKeyRing[ bKeyRingPosition ].ubNumber;
		}

		
		ubItems = pSoldier->pKeyRing[ bKeyRingPosition ].ubKeyID;
		if( pSoldier->pKeyRing[ bKeyRingPosition ].ubNumber - ubNumberOfKeys > 0 )
		{
			pSoldier->pKeyRing[ bKeyRingPosition ].ubNumber--;
		}
		else
		{
			pSoldier->pKeyRing[ bKeyRingPosition ].ubNumber = 0;
			pSoldier->pKeyRing[ bKeyRingPosition ].ubKeyID = INVALID_KEY_NUMBER;
		}

		// create an object
		return( CreateKeyObject( pObj, ubNumberOfKeys, ubItems ) );
	}
}

// return number added
UINT8 AddKeysToSlot( SOLDIERTYPE * pSoldier, INT8 bKeyRingPosition, OBJECTTYPE * pObj )
{
	UINT8 ubNumberNotAdded = 0;

	if ( pSoldier->uiStatusFlags & SOLDIER_PC ) // redundant but what the hey
	{
		if ( KeyTable[ pObj->ubKeyID ].usDateFound == 0 )
		{
			KeyTable[ pObj->ubKeyID ].usDateFound = (UINT16) GetWorldDay();
			KeyTable[ pObj->ubKeyID ].usSectorFound = SECTOR( pSoldier->sSectorX, pSoldier->sSectorY );
		}
	}

	// check if we are going to far
	if ( ( pSoldier->pKeyRing[ bKeyRingPosition ].ubNumber + pObj->ubNumberOfObjects ) > Item[ pObj->usItem ].ubPerPocket )
	{
		// only take what we can
		ubNumberNotAdded = pObj->ubNumberOfObjects - ( Item[ pObj->usItem ].ubPerPocket - pSoldier->pKeyRing[ bKeyRingPosition ].ubNumber );
		
		// set to max
		pSoldier->pKeyRing[ bKeyRingPosition ].ubNumber = Item[ pObj->usItem ].ubPerPocket; 
		
		if( pSoldier->pKeyRing[ bKeyRingPosition ].ubNumber == 0 )
		{
			pSoldier->pKeyRing[ bKeyRingPosition ].ubKeyID = pObj->ubKeyID;
		}

		// return number used
		return( pObj->ubNumberOfObjects - ubNumberNotAdded );
	}
	else 
	{
		// check 
		if( pSoldier->pKeyRing[ bKeyRingPosition ].ubNumber == 0 )
		{
			pSoldier->pKeyRing[ bKeyRingPosition ].ubKeyID = pObj->ubKeyID;
		}

		pSoldier->pKeyRing[ bKeyRingPosition ].ubNumber += pObj->ubNumberOfObjects;
	}

	return( pObj->ubNumberOfObjects );
}

UINT8 SwapKeysToSlot( SOLDIERTYPE * pSoldier, INT8 bKeyRingPosition, OBJECTTYPE * pObj )
{
	// swap keys in keyring slot and keys in pocket
	UINT8 ubNumberNotAdded = 0;
	OBJECTTYPE	TempObj;

	// create temp object to hold keys currently in key ring slot
	CreateKeyObject( &TempObj, pSoldier->pKeyRing[ bKeyRingPosition ].ubNumber, pSoldier->pKeyRing[ bKeyRingPosition ].ubKeyID );

	pSoldier->pKeyRing[ bKeyRingPosition ].ubNumber = pObj->ubNumberOfObjects;
	pSoldier->pKeyRing[ bKeyRingPosition ].ubKeyID = pObj->ubKeyID;
	
	// swap params?
	CopyObj( &TempObj, pObj );

	return( 1 );
}


BOOLEAN CreateKeyObject( OBJECTTYPE * pObj , UINT8 ubNumberOfKeys, UINT8 ubKeyID )
{
	BOOLEAN fRet;

	fRet = CreateItems( (UINT16) (FIRST_KEY + LockTable[ ubKeyID ].usKeyItem), 100, ubNumberOfKeys, pObj );
	if (fRet)
	{
		pObj->ubKeyID = ubKeyID;
	}
	//fRet = CreateItems( (UINT16)(ubKeyIdValue + FIRST_KEY) , 100, ubNumberOfKeys, pObj )
	//return(  );
	return( fRet );
}


BOOLEAN AllocateObject( OBJECTTYPE **pObj )
{
	// create a key object
	*pObj = MemAlloc( sizeof( OBJECTTYPE ) );
	Assert( pObj );

	return( TRUE );
}

BOOLEAN DeleteKeyObject( OBJECTTYPE * pObj )
{
	if( pObj == FALSE )
	{
		return( FALSE );
	}

	// free up space
	MemFree( pObj );

	return( TRUE );
}

UINT16 TotalPoints( OBJECTTYPE * pObj )
{
	UINT16	usPoints = 0;
	UINT8		ubLoop;

	for (ubLoop = 0; ubLoop < pObj->ubNumberOfObjects; ubLoop++)
	{
		usPoints += pObj->bStatus[ubLoop];
	}
	return( usPoints );
}

UINT16 UseKitPoints( OBJECTTYPE * pObj, UINT16 usPoints, SOLDIERTYPE *pSoldier )
{
	// start consuming from the last kit in, so we end up with fewer fuller kits rather than
	// lots of half-empty ones.
	INT8		bLoop;
	UINT16 usOriginalPoints = usPoints;

	for (bLoop = pObj->ubNumberOfObjects - 1; bLoop >= 0; bLoop--)
	{
		if (usPoints < (UINT16) pObj->bStatus[bLoop])
		{
			pObj->bStatus[bLoop] -= (INT8) usPoints;
			return( usOriginalPoints );
		}
		else
		{
			// consume this kit totally
			usPoints -= pObj->bStatus[bLoop];
			pObj->bStatus[bLoop] = 0;

			pObj->ubNumberOfObjects--;
		}
	}

	// check if pocket/hand emptied..update inventory, then update panel
	if( pObj->ubNumberOfObjects == 0 )
	{
		// Delete object
		DeleteObj( pObj );

		// dirty interface panel
		DirtyMercPanelInterface(  pSoldier, DIRTYLEVEL2 );
	}

	return( usOriginalPoints -  usPoints );
}

#ifdef PATHAI_VISIBLE_DEBUG

	extern BOOLEAN gfDrawPathPoints;

	void DoChrisTest( SOLDIERTYPE * pSoldier )
	{
	//	GenerateMapEdgepoints();

			//gfDrawPathPoints = !gfDrawPathPoints;

		//gfDrawPathPoints = TRUE;
		//GlobalReachableTest( pSoldier->sGridNo );
		//gfDrawPathPoints = FALSE;

	}

#else

	#ifdef AI_TIMING_TESTS
	extern UINT32 guiGreenTimeTotal, guiYellowTimeTotal, guiRedTimeTotal, guiBlackTimeTotal;
	extern UINT32 guiGreenCounter, guiYellowCounter, guiRedCounter, guiBlackCounter;
	extern UINT32 guiRedSeekTimeTotal, guiRedHelpTimeTotal, guiRedHideTimeTotal;
	extern UINT32 guiRedSeekCounter, guiRedHelpCounter; guiRedHideCounter;
	#endif

	void DoChrisTest( SOLDIERTYPE * pSoldier )
	{
		/*
		UINT32 uiLoop;

		for ( uiLoop = 0; uiLoop < guiNumMercSlots; uiLoop++ )
		{
			if ( MercSlots[ uiLoop ] && MercSlots[ uiLoop ]->bTeam == ENEMY_TEAM )
			{
				if ( MercSlots[ uiLoop ]->ubSkillTrait1 == NIGHTOPS )
				{
					DebugMsg( TOPIC_JA2, DBG_LEVEL_3, String( "Soldier %d has nightops 1", MercSlots[ uiLoop ]->ubID ) );
				}
				if ( MercSlots[ uiLoop ]->ubSkillTrait2 == NIGHTOPS )
				{
					DebugMsg( TOPIC_JA2, DBG_LEVEL_3, String( "Soldier %d has nightops 2", MercSlots[ uiLoop ]->ubID ) );
				}
				if ( MercSlots[ uiLoop ]->inv[ HEAD1POS ].usItem != NOTHING )
				{
					DebugMsg( TOPIC_JA2, DBG_LEVEL_3, String( "%S", ItemNames[ MercSlots[ uiLoop ]->inv[ HEAD1POS ].usItem ] ) );
				}
				if ( MercSlots[ uiLoop ]->inv[ HEAD2POS ].usItem != NOTHING )
				{
					DebugMsg( TOPIC_JA2, DBG_LEVEL_3, String( "%S", ItemNames[ MercSlots[ uiLoop ]->inv[ HEAD2POS ].usItem ] ) );
				}

			}
		}
		*/
	
				UINT32	uiLoop;


		for ( uiLoop = 0; uiLoop <= HISTORY_MERC_KILLED_CHARACTER; uiLoop++ )
		{
			switch( uiLoop ) 
			{
				case HISTORY_FOUND_MONEY:
				case HISTORY_ASSASSIN:
				case HISTORY_DISCOVERED_TIXA:
				case HISTORY_DISCOVERED_ORTA:
				case HISTORY_GOT_ROCKET_RIFLES:
				case HISTORY_DEIDRANNA_DEAD_BODIES:
				case HISTORY_BOXING_MATCHES:
				case HISTORY_SOMETHING_IN_MINES:
				case HISTORY_DEVIN:
				case HISTORY_MIKE:
				case HISTORY_TONY:
				case HISTORY_KROTT:
				case HISTORY_KYLE:
				case HISTORY_MADLAB:
				case HISTORY_GABBY:
				case HISTORY_KEITH_OUT_OF_BUSINESS:
				case HISTORY_HOWARD_CYANIDE:
				case HISTORY_KEITH:
				case HISTORY_HOWARD:
				case HISTORY_PERKO:
				case HISTORY_SAM:
				case HISTORY_FRANZ:
				case HISTORY_ARNOLD:
				case HISTORY_FREDO:
				case HISTORY_RICHGUY_BALIME:
				case HISTORY_JAKE:
				case HISTORY_BUM_KEYCARD:
				case HISTORY_WALTER:
				case HISTORY_DAVE:
				case HISTORY_PABLO:
				case HISTORY_KINGPIN_MONEY:
				//VARIOUS BATTLE CONDITIONS
				case HISTORY_LOSTTOWNSECTOR:
				case HISTORY_DEFENDEDTOWNSECTOR:
				case HISTORY_LOSTBATTLE:
				case HISTORY_WONBATTLE:
				case HISTORY_FATALAMBUSH:
				case HISTORY_WIPEDOUTENEMYAMBUSH:
				case HISTORY_UNSUCCESSFULATTACK:
				case HISTORY_SUCCESSFULATTACK:
				case HISTORY_CREATURESATTACKED:
				case HISTORY_KILLEDBYBLOODCATS:
				case HISTORY_SLAUGHTEREDBLOODCATS:
				case HISTORY_GAVE_CARMEN_HEAD:
				case HISTORY_SLAY_MYSTERIOUSLY_LEFT:
					AddHistoryToPlayersLog( (UINT8) uiLoop, 0, GetWorldTotalMin(), gWorldSectorX, gWorldSectorY );
					break;
				default:
					break;
			}
			
		}
		

		/*
		UINT32		uiEntryTime, uiExitTime;
		UINT32		uiLoop;

		for ( uiLoop = 0; uiLoop < guiNumMercSlots; uiLoop++ )
		{
			if ( MercSlots[ uiLoop ] && MercSlots[ uiLoop ]->bTeam == CIV_TEAM )
			{
				pSoldier = MercSlots[ uiLoop ];
				if ( ExtractScheduleEntryAndExitInfo( pSoldier, &uiEntryTime, &uiExitTime ) )
				{
					ScreenMsg( FONT_MCOLOR_LTYELLOW, MSG_INTERFACE, L"Civ %d enters at %ld, exits at %ld", pSoldier->ubID, uiEntryTime, uiExitTime );	
				}
			}
		}
		*/
/*
		UINT32	 uiLoop;

		for ( uiLoop = 0; uiLoop <= 4; uiLoop++ )
		{
			ScreenMsg( FONT_MCOLOR_LTYELLOW, MSG_INTERFACE, L"Team %d has %d people", uiLoop, gTacticalStatus.Team[ uiLoop ].bMenInSector );
		}
		*/
	/*
		UINT32	uiLoop;
		INT16		sGridNo;
		UINT32	uiStartTime, uiEndTime;

		if (GetMouseMapPos( &sGridNo ))
		{
			uiStartTime = GetJA2Clock();
			for (uiLoop = 0; uiLoop < 50000; uiLoop++)
			{
				FindBestPath( pSoldier, sGridNo, pSoldier->bLevel, WALKING, COPYROUTE );
			}
			uiEndTime = GetJA2Clock();
			DebugMsg( TOPIC_JA2, DBG_LEVEL_3, String( "50000 path calls from %d to %d took %ld ms", pSoldier->sGridNo, sGridNo, uiEndTime - uiStartTime ) );
		}
		*/
	}
#endif


UINT16 MagazineClassIndexToItemType(UINT16 usMagIndex)
{
	UINT16				usLoop;

	// Note: if any ammo items in the item table are separated from the main group,
	// this function will have to be rewritten to scan the item table for an item
	// with item class ammo, which has class index usMagIndex
	for (usLoop = 0; usLoop < MAXITEMS; usLoop++)
	{
		if (Item[usLoop].usItemClass == IC_AMMO && Item[usLoop].ubClassIndex == usMagIndex)
		{
			return( usLoop );
		}
	}

	return(NONE);
}

//<SB>       ,  ..     
//   
UINT16 DefaultMagazine( UINT16 usItem )
{
	WEAPONTYPE *	pWeapon;
	UINT16			usLoop;
	UINT16			usAmmoBox = NONE;

	if (!(Item[usItem].usItemClass & IC_GUN))
	{
		return( 0 );
	}

	pWeapon = &(Weapon[ Item[usItem].ubClassIndex]);
// 0.98 beta 18: adjusted to pass past skipped ammo
	for( usLoop = 0; usLoop < MAX_MAGAZINES; usLoop++ )
	{
		if ( !pWeapon->ubFixedMag && Magazine[usLoop].ubCalibre == pWeapon->ubCalibre &&
				Magazine[usLoop].ubFeedType == pWeapon->ubFeedType &&
				Magazine[usLoop].ubMagSize == pWeapon->ubMagSize
		)
			return(MagazineClassIndexToItemType(usLoop));
		// find first compatible ammo box
		if ( !usAmmoBox && Magazine[usLoop].ubCalibre==pWeapon->ubCalibre && Magazine[usLoop].ubFeedType==255 )
			usAmmoBox = MagazineClassIndexToItemType(usLoop);
	}

	return( usAmmoBox );
}
//</SB>

UINT16 FindReplacementMagazine( UINT8 ubCalibre, UINT8 ubMagSize, UINT8 ubAmmoType )
{
	UINT8 ubLoop;
	UINT16 usDefault;
	
	ubLoop = 0;
	usDefault = NOTHING;

	while ( Magazine[ubLoop].ubCalibre != NOAMMO )
	{
		if (Magazine[ubLoop].ubCalibre == ubCalibre &&
				Magazine[ubLoop].ubMagSize == ubMagSize )
		{
			if ( Magazine[ubLoop].ubAmmoType == ubAmmoType )
			{
				return( MagazineClassIndexToItemType( ubLoop ) );
			}
			else if ( usDefault == NOTHING )
			{
				// store this one to use if all else fails
				usDefault = MagazineClassIndexToItemType( ubLoop );
			}
			
		}

		ubLoop++;
	}

	return( usDefault );

}

UINT16 FindReplacementMagazineIfNecessary( UINT16 usOldGun, UINT16 usOldAmmo, UINT16 usNewGun )
{
	UINT16 usNewAmmo = NOTHING;

	if ( (Magazine[ Item[ usOldAmmo ].ubClassIndex ].ubCalibre == Weapon[ Item[ usOldGun].ubClassIndex ].ubCalibre) &&
//			 (Magazine[ Item[ usOldAmmo ].ubClassIndex ].ubMagSize == Weapon[ Item[ usOldGun].ubClassIndex ].ubMagSize) )
			 (Magazine[ Item[ usOldAmmo ].ubClassIndex ].ubFeedType == Weapon[ Item[ usOldGun].ubClassIndex ].ubFeedType) )
	{
		// must replace this!
		usNewAmmo = FindReplacementMagazine( Weapon[ Item[ usNewGun].ubClassIndex ].ubCalibre, Weapon[ Item[ usNewGun].ubClassIndex ].ubMagSize, Magazine[ Item[ usOldAmmo ].ubClassIndex ].ubAmmoType );
	}

	return( usNewAmmo );
}

// increase this if any gun can have more types that this
#define MAX_AMMO_TYPES_PER_GUN		64

UINT16 RandomMagazine( UINT16 usItem, UINT8 ubPercentStandard )
{
	// Note: if any ammo items in the item table are separated from the main group,
	// this function will have to be rewritten to scan the item table for an item
	// with item class ammo, which has class index ubLoop

	WEAPONTYPE *	pWeapon;
	UINT16				usLoop;
	UINT16				usPossibleMagIndex[ MAX_AMMO_TYPES_PER_GUN ];
	UINT16				usPossibleMagCnt = 0;
	INT32					ubMagChosen = -1;

	if (!(Item[usItem].usItemClass & IC_GUN))
	{
		return( 0 );
	}

	pWeapon = &(Weapon[ Item[usItem].ubClassIndex]);

	// find & store all possible mag types that fit this gun
	usLoop = 0;
	while ( Magazine[ usLoop ].ubCalibre != NOAMMO )
	{
		if (Magazine[usLoop].ubCalibre == pWeapon->ubCalibre &&
//				Magazine[usLoop].ubMagSize == pWeapon->ubMagSize)
				Magazine[usLoop].ubFeedType == pWeapon->ubFeedType)
		{
			// store it! (make sure array is big enough)
			Assert(usPossibleMagCnt < MAX_AMMO_TYPES_PER_GUN);
			if( Magazine[usLoop].ubMagSize == pWeapon->ubMagSize && ubMagChosen < 0)
				ubMagChosen = usPossibleMagCnt;
			usPossibleMagIndex[usPossibleMagCnt++] = usLoop;
		}

		usLoop++;
	}

	// no matches?
	if (usPossibleMagCnt == 0)
	{
		return( 0 );
	}
	else
	// only one match?
	if (usPossibleMagCnt == 1)
	{
		// use that, no choice
		return(MagazineClassIndexToItemType(usPossibleMagIndex[ 0 ] ));
	}
	else	// multiple choices
	{
		// Pick one at random, using supplied probability to pick the default
		if (Random(100) < ubPercentStandard)
		{
//			ubMagChosen = 0;
		}
		else
		{
			// pick a non-standard type instead
			ubMagChosen = ( UINT8 ) (1 + Random(( UINT32 ) ( usPossibleMagCnt - 1 )));
		}

		return( MagazineClassIndexToItemType(usPossibleMagIndex[ ubMagChosen ] ) );
	}
}

//<SB> modified to provide creation of gun with detachable magazines
BOOLEAN CreateGun( UINT16 usItem, INT8 bStatus, OBJECTTYPE * pObj )
{
	UINT16 usAmmo;


	Assert( pObj != NULL);
	if ( pObj == NULL )
	{
		return( FALSE );
	}

	memset( pObj, 0, sizeof( OBJECTTYPE ) );
	pObj->usItem = usItem;
	pObj->ubNumberOfObjects = 1;
	pObj->bGunStatus = bStatus;
	pObj->ubImprintID = NO_PROFILE;
	pObj->ubWeight = CalculateObjectWeight( pObj );

	if (Weapon[ Item[ usItem].ubClassIndex ].ubWeaponClass == MONSTERCLASS)
		pObj->ubGunShotsLeft = Weapon[ Item[ usItem].ubClassIndex ].ubMagSize;
	else if ( EXPLOSIVE_GUN( usItem ) )
	{
		if ( usItem == ROCKET_LAUNCHER )
		{
			pObj->ubGunShotsLeft = 1;
		}
		else
		{
			// cannon
			pObj->ubGunShotsLeft = 0;
		}
		pObj->bGunAmmoStatus = 100;
//		pObj->ubGunAmmoType = 0;
	}
	else
	{
		usAmmo = DefaultMagazine( usItem );
		Assert( usAmmo != 0 || Weapon[ Item[ usItem].ubClassIndex ].ubFixedMag);
		if (usAmmo == 0 && !Weapon[ Item[ usItem].ubClassIndex ].ubFixedMag)
		{
			// item's calibre & mag size not found in magazine list!
			return( FALSE );
		}
		else
		{
			pObj->usGunAmmoItem = usAmmo;
//			pObj->ubGunAmmoType = Magazine[ Item[ usAmmo ].ubClassIndex].ubAmmoType;
			pObj->bGunAmmoStatus = 100;
			pObj->ubGunShotsLeft = Magazine[ Item[ usAmmo ].ubClassIndex].ubFeedType==255?
											Weapon[ Item[ usItem].ubClassIndex ].ubMagSize:
											Magazine[ Item[ usAmmo ].ubClassIndex ].ubMagSize;
			/*
			if (usItem == CAWS)
			{
				pObj->usAttachItem[0] = DUCKBILL;
				pObj->bAttachStatus[0] = 100;
			}
			*/
		}
	}

	// succesful
	return( TRUE );
}
//</SB>

BOOLEAN CreateMagazine( UINT16 usItem, OBJECTTYPE * pObj )
{
	if (pObj == NULL)
	{
		return( FALSE );
	}
	memset( pObj, 0, sizeof( OBJECTTYPE ) );
	pObj->usItem = usItem;
	pObj->ubNumberOfObjects = 1;
	pObj->ubShotsLeft[0] = Magazine[ Item[usItem].ubClassIndex ].ubMagSize;
	pObj->ubWeight = CalculateObjectWeight( pObj );
	return( TRUE );
}

BOOLEAN CreateItem( UINT16 usItem, INT8 bStatus, OBJECTTYPE * pObj )
{
	BOOLEAN fRet;

	memset( pObj, 0, sizeof( OBJECTTYPE ) );
	if (usItem >= MAXITEMS)
	{
		return( FALSE );
	}
	if (Item[ usItem ].usItemClass == IC_GUN)
	{
		fRet = CreateGun( usItem, bStatus, pObj );
	}
	else if (Item[ usItem ].usItemClass == IC_AMMO)
	{
		fRet = CreateMagazine( usItem, pObj );		
	}
	else
	{
		pObj->usItem = usItem;
		pObj->ubNumberOfObjects = 1;
		if (usItem == MONEY)
		{
			// special case... always set status to 100 when creating
			// and use status value to determine amount!
			pObj->bStatus[0] = 100;
			pObj->uiMoneyAmount = bStatus * 50;
		}
		else
		{
			pObj->bStatus[0] = bStatus;
		}
		pObj->ubWeight = CalculateObjectWeight( pObj );
		fRet = TRUE;
	}
	if (fRet)
	{
		if (Item[ usItem ].fFlags & ITEM_DEFAULT_UNDROPPABLE)
		{
			pObj->fFlags |= OBJECT_UNDROPPABLE;
		}
	}
	return( fRet );
}

BOOLEAN CreateItems( UINT16 usItem, INT8 bStatus, UINT8 ubNumber, OBJECTTYPE * pObj )
{
	BOOLEAN fOk;
	UINT8		ubLoop;

	// can't create any more than this, the loop for setting the bStatus[] of others will overwrite memory!
	Assert( ubNumber <= MAX_OBJECTS_PER_SLOT );

	// ARM: to avoid whacking memory once Assertions are removed...  Items will be lost in this situation!
	if ( ubNumber > MAX_OBJECTS_PER_SLOT )
	{
		ubNumber = MAX_OBJECTS_PER_SLOT;
	}

	fOk = CreateItem( usItem, bStatus, pObj );
	if (fOk)
	{
		for (ubLoop = 1; ubLoop < ubNumber; ubLoop++)	
		{
			// we reference status[0] here because the status value might actually be a
			// # of rounds of ammo, in which case the value won't be the bStatus value 
			// passed in.
			pObj->bStatus[ubLoop] = pObj->bStatus[0];
		}
		pObj->ubNumberOfObjects = ubNumber;
		pObj->ubWeight *= ubNumber;
		return( TRUE );
	}
	return( FALSE );
}

BOOLEAN CreateMoney( UINT32 uiMoney, OBJECTTYPE * pObj )
{
	BOOLEAN fOk; 

	fOk = CreateItem( MONEY, 100, pObj );
	if (fOk)
	{
		pObj->uiMoneyAmount = uiMoney;
	}
	return( fOk );
}

BOOLEAN ArmBomb( OBJECTTYPE * pObj, INT8 bSetting )
{
	BOOLEAN fRemote = FALSE;
	BOOLEAN fPressure = FALSE;
	BOOLEAN fTimed = FALSE;
	BOOLEAN	fSwitch = FALSE;

	if (pObj->usItem == ACTION_ITEM)
	{
		switch( pObj->bActionValue )
		{
			case ACTION_ITEM_SMALL_PIT:
			case ACTION_ITEM_LARGE_PIT:
				fPressure = TRUE;
				break;
			default:
				fRemote = TRUE;
				break;

		}
	}
	else if ( FindAttachment( pObj, DETONATOR ) != ITEM_NOT_FOUND )
	{
		fTimed = TRUE;
	}
	else if ( (FindAttachment( pObj, REMDETONATOR ) != ITEM_NOT_FOUND) || (pObj->usItem == ACTION_ITEM) )
	{
		fRemote = TRUE;
	}
	else if ( pObj->usItem == MINE || pObj->usItem == TRIP_FLARE || pObj->usItem == TRIP_KLAXON || pObj->usItem == ACTION_ITEM )
	{
		fPressure = TRUE;
	}
	else if ( pObj->usItem == SWITCH )
	{
		// this makes a remote detonator into a pressure-sensitive trigger
		if ( bSetting == PANIC_FREQUENCY )
		{
			// panic trigger is only activated by expending APs, not by
			// stepping on it... so don't define a detonator type
			fSwitch = TRUE;
		}
		else
		{
			fPressure = TRUE;
		}
	}
	else
	{
		// no sorta bomb at all!
		return( FALSE );
	}

	if (fRemote)
	{
		pObj->bDetonatorType = BOMB_REMOTE;
		pObj->bFrequency = bSetting;
	}
	else if (fPressure)
	{
		pObj->bDetonatorType = BOMB_PRESSURE;
		pObj->bFrequency = 0;
	}
	else if (fTimed)
	{
		pObj->bDetonatorType = BOMB_TIMED;
		// In realtime the player could choose to put down a bomb right before a turn expires, SO
		// add 1 to the setting in RT
		pObj->bDelay = bSetting;
		if ( !(gTacticalStatus.uiFlags & TURNBASED && gTacticalStatus.uiFlags & INCOMBAT) )
		{
			pObj->bDelay++;
		}

	}
	else if (fSwitch)
	{
		pObj->bDetonatorType = BOMB_SWITCH;
		pObj->bFrequency = bSetting;
	}
	else
	{
		return( FALSE );
	}

	pObj->fFlags |= OBJECT_ARMED_BOMB;
	pObj->usBombItem = pObj->usItem;
	return( TRUE );
}

void RenumberAttachments( OBJECTTYPE * pObj )
{
	// loop through attachment positions and make sure we don't have any empty
	// attachment slots before filled ones
	INT8			bAttachPos;
	INT8			bFirstSpace;
	BOOLEAN		fDone = FALSE;

	while (!fDone)
	{
		bFirstSpace = -1;
		for (bAttachPos = 0; bAttachPos < MAX_ATTACHMENTS; bAttachPos++)
		{
			if (pObj->usAttachItem[ bAttachPos ] == NOTHING)
			{
				if (bFirstSpace == -1)
				{
					bFirstSpace = bAttachPos;
				}
			}
			else
			{
				if (bFirstSpace != -1)
				{
					// move the attachment!
					pObj->usAttachItem[ bFirstSpace ] = pObj->usAttachItem[ bAttachPos ];
					pObj->bAttachStatus[ bFirstSpace ] = pObj->bAttachStatus[ bAttachPos ];
					pObj->usAttachItem[ bAttachPos ] = NOTHING;
					pObj->bAttachStatus[ bAttachPos ] = 0;				
					// restart loop at beginning, or quit if we reached the end of the
					// attachments
					break;
				}
			}
		}
		if (bAttachPos == MAX_ATTACHMENTS)
		{
			// done!!
			fDone = TRUE;
		}
	}

}

BOOLEAN RemoveAttachment( OBJECTTYPE * pObj, INT8 bAttachPos, OBJECTTYPE * pNewObj )
{
	INT8		bGrenade;
	INT8		bIndex = 0;

	CHECKF( pObj );
	
	if (bAttachPos < 0 || bAttachPos >= MAX_ATTACHMENTS)
	{
		return( FALSE );
	}
	if (pObj->usAttachItem[bAttachPos] == NOTHING )
	{
		return( FALSE );
	}

//SB: I've decided to comment this to remove stupid inseparable attachments
//	if ( Item[ pObj->usAttachItem[bAttachPos] ].fFlags & ITEM_INSEPARABLE )
//	{
//		return( FALSE );
//	}

	// if pNewObj is passed in NULL, then we just delete the attachment
	if (pNewObj != NULL)
	{
		CreateItem( pObj->usAttachItem[bAttachPos], pObj->bAttachStatus[bAttachPos], pNewObj );
	}

	pObj->usAttachItem[bAttachPos] = NOTHING;
	pObj->bAttachStatus[bAttachPos] = 0;
	
	if (pNewObj && pNewObj->usItem == UNDER_GLAUNCHER)
	{
		// look for any grenade; if it exists, we must make it an 
		// attachment of the grenade launcher
		bGrenade = FindAttachmentByClass( pObj, IC_GRENADE );
		if (bGrenade != ITEM_NOT_FOUND)
		{
			pNewObj->usAttachItem[0] = pObj->usAttachItem[bGrenade];
			pNewObj->bAttachStatus[0] = pObj->bAttachStatus[bGrenade];
			pObj->usAttachItem[bGrenade] = NOTHING;
			pObj->bAttachStatus[bGrenade] = 0;
			pNewObj->ubWeight = CalculateObjectWeight( pNewObj );
		}
	}

	RenumberAttachments( pObj );

	pObj->ubWeight = CalculateObjectWeight( pObj );

//<SB> for removable tripod
	while( AttachmentComboMerge[ bIndex ].usItem != NOTHING )
	{
		if ( pObj->usItem == AttachmentComboMerge[ bIndex ].usResult )
		{
			if ( AttachmentComboMerge[ bIndex ].usAttachment[0] == pNewObj->usItem || 
				AttachmentComboMerge[ bIndex ].usAttachment[1] == pNewObj->usItem )
			{
				pObj->usItem = AttachmentComboMerge[ bIndex ].usItem;
				if(!AttachmentComboMerge[ bIndex ].usAttachment[1])
				{
					pObj->bStatus[0] = ((int)pObj->bStatus[0] - pNewObj->bStatus[0])/2 + pNewObj->bStatus[0];
				}
			}
			return( TRUE );
		}
		bIndex++;
	}
//</SB>
	return( TRUE );
}

void SetNewItem( SOLDIERTYPE *pSoldier, UINT8 ubInvPos, BOOLEAN fNewItem )
{
	if( fNewItem )
	{
		pSoldier->bNewItemCount[ ubInvPos ]						 = -1;
		pSoldier->bNewItemCycleCount[ ubInvPos ]			 = NEW_ITEM_CYCLE_COUNT;
		pSoldier->fCheckForNewlyAddedItems             = TRUE;
	}
}


BOOLEAN PlaceObjectInSoldierProfile( UINT8 ubProfile, OBJECTTYPE *pObject )
{
	INT8				bLoop, bLoop2;
	SOLDIERTYPE *pSoldier;
	UINT16			usItem;
	INT8				bStatus;
	BOOLEAN			fReturnVal = FALSE;

	usItem	= pObject->usItem;
	bStatus = pObject->bStatus[0];
	pSoldier = FindSoldierByProfileID( ubProfile, FALSE );

	if ( Item[ usItem ].usItemClass == IC_MONEY && gMercProfiles[ ubProfile ].uiMoney > 0 )
	{
		gMercProfiles[ ubProfile ].uiMoney += pObject->uiMoneyAmount;
		SetMoneyInSoldierProfile( ubProfile, gMercProfiles[ ubProfile ].uiMoney );
		return( TRUE );
	}

	for (bLoop = BIGPOCK1POS; bLoop < SMALLPOCK8POS; bLoop++)
	{
		if ( gMercProfiles[ ubProfile ].bInvNumber[ bLoop ] == 0 && (pSoldier == NULL || pSoldier->inv[ bLoop ].usItem == NOTHING ) )
		{

			// CJC: Deal with money by putting money into # stored in profile
			if ( Item[ usItem ].usItemClass == IC_MONEY )
			{
				gMercProfiles[ ubProfile ].uiMoney += pObject->uiMoneyAmount;
				// change any gold/silver to money
				usItem = MONEY;
			}
			else
			{
				gMercProfiles[ ubProfile ].inv[ bLoop ] = usItem;
				gMercProfiles[ ubProfile ].bInvStatus[ bLoop ] = bStatus;
				gMercProfiles[ ubProfile ].bInvNumber[ bLoop ] = pObject->ubNumberOfObjects;	
			}

			fReturnVal = TRUE;
			break;
		}
	}

	//uiMoneyAmount
	if ( fReturnVal )
	{
		// ATE: Manage soldier pointer as well....
		//pSoldier = FindSoldierByProfileID( ubProfile, FALSE );

		// Do we have a valid profile?
		if ( pSoldier != NULL )
		{
			// OK, place in soldier...
			if ( usItem == MONEY )
			{
				CreateMoney( gMercProfiles[ ubProfile ].uiMoney, &(pSoldier->inv[ bLoop ] ) );
			}
			else
			{
				if ( pSoldier->ubProfile == MADLAB )
				{
					// remove attachments and drop them
					OBJECTTYPE			Attachment;

					for ( bLoop2 = MAX_ATTACHMENTS - 1; bLoop2 >= 0; bLoop2-- )
					{
						// remove also checks for existence attachment
						if ( RemoveAttachment( pObject, bLoop2, &Attachment ) == TRUE )
						{
							// drop it in Madlab's tile
							AddItemToPool( pSoldier->sGridNo, &Attachment, 1, 0, 0, 0 );
						}
					}
				}

				CreateItem( usItem, bStatus, &(pSoldier->inv[ bLoop ] ) );
			}
		}
	}

	return( fReturnVal );
}

BOOLEAN RemoveObjectFromSoldierProfile( UINT8 ubProfile, UINT16 usItem )
{
	INT8 bLoop;
	SOLDIERTYPE *pSoldier;
	BOOLEAN	fReturnVal = FALSE;

	if ( usItem == NOTHING )
	{
		return( TRUE );
	}

	for (bLoop = 0; bLoop < 19; bLoop++)
	{
		if ( gMercProfiles[ ubProfile ].inv[ bLoop ] == usItem )
		{
			gMercProfiles[ ubProfile ].inv[ bLoop ] = NOTHING;
			gMercProfiles[ ubProfile ].bInvStatus[ bLoop ] = 0;
			gMercProfiles[ ubProfile ].bInvNumber[ bLoop ] = 0;				

			fReturnVal = TRUE;
			break;
		}
	}

	// ATE: Manage soldier pointer as well....
	pSoldier = FindSoldierByProfileID( ubProfile, FALSE );

	// Do we have a valid profile?
	if ( pSoldier != NULL )
	{
		// Remove item...
		RemoveInvObject( pSoldier, usItem );
	}

	return( fReturnVal );
}


void SetMoneyInSoldierProfile( UINT8 ubProfile, UINT32 uiMoney )
{
	//INT8						bSlot;
	OBJECTTYPE			Object;
	//SOLDIERTYPE *		pSoldier;
	BOOLEAN					fRet;

	// remove all money from soldier	
	do
	{
		fRet = RemoveObjectFromSoldierProfile( ubProfile, MONEY );
	}
	while ( fRet == TRUE );

	gMercProfiles[ ubProfile ].uiMoney = 0;

	if (uiMoney > 0)
	{
		// now add the amount specified
		CreateMoney( uiMoney, &Object );
		PlaceObjectInSoldierProfile( ubProfile, &Object );
	}
}

INT8 FindObjectInSoldierProfile( UINT8 ubProfile, UINT16 usItem )
{
	INT8	bLoop;

	for (bLoop = 0; bLoop < 19; bLoop++)
	{
		if ( gMercProfiles[ ubProfile ].bInvNumber[ bLoop ] > 0 )
		{
			if ( gMercProfiles[ ubProfile ].inv[ bLoop ] == usItem )
			{
				return( bLoop );
			}
		}
	}
	return( NO_SLOT );
}

BOOLEAN ObjectExistsInSoldierProfile( UINT8 ubProfile, UINT16 usItem )
{
	INT8	bSlot;

	bSlot = FindObjectInSoldierProfile( ubProfile, usItem );
	return( bSlot != NO_SLOT );
}

void RemoveInvObject( SOLDIERTYPE *pSoldier, UINT16 usItem )
{
	INT8 bInvPos;

	// find object
	bInvPos = FindObj( pSoldier, usItem );
	if (bInvPos != NO_SLOT)
	{

		// Erase!
		memset( &(pSoldier->inv[ bInvPos ]), 0, sizeof( OBJECTTYPE ) );

		//Dirty!
		DirtyMercPanelInterface( pSoldier, DIRTYLEVEL2 );
	}

}

INT8 CheckItemForDamage( UINT16 usItem, INT32 iMaxDamage )
{
	INT8	bDamage = 0;

	// if the item is protective armour, reduce the amount of damage
	// by its armour value
	if (Item[usItem].usItemClass == IC_ARMOUR)
	{
		iMaxDamage -= (iMaxDamage * Armour[Item[usItem].ubClassIndex].ubProtection) / 100;
	}
	// metal items are tough and will be damaged less
	if (Item[usItem].fFlags & ITEM_METAL)
	{
		iMaxDamage /= 2;
	}
	else if ( usItem == BLOODCAT_PELT )
	{
		iMaxDamage *= 2;
	}
	if (iMaxDamage > 0)
	{
		bDamage = (INT8) PreRandom( iMaxDamage );
	}
	return( bDamage );
}

BOOLEAN CheckForChainReaction( UINT16 usItem, INT8 bStatus, INT8 bDamage, BOOLEAN fOnGround )
{
	INT32 iChance;

	iChance = Explosive[Item[usItem].ubClassIndex].ubVolatility;
	if (iChance > 0)
	{
		
		// Scale the base chance by the damage caused to the item
		// (bigger the shock, bigger chance) and the condition of 
		// the item after being hit!
		if (fOnGround)
		{
			// improve chance to make it practical to blow up explosives on the ground
			iChance = 50 + (iChance - 1) * 10;
		}

		iChance = iChance * ( 100 + ( (100 - bStatus) + bDamage ) / 2 ) / 100;
		if ((INT32) PreRandom( 100 ) < iChance)
		{
			return( TRUE );
		}
	}
	return( FALSE );
}

BOOLEAN DamageItem( OBJECTTYPE * pObject, INT32 iDamage, BOOLEAN fOnGround )
{
	INT8		bLoop;
	INT8		bDamage;

	if ( (Item[pObject->usItem].fFlags & ITEM_DAMAGEABLE || Item[ pObject->usItem ].usItemClass == IC_AMMO) && pObject->ubNumberOfObjects > 0)
	{

		for (bLoop = 0; bLoop < pObject->ubNumberOfObjects; bLoop++)
		{
			// if the status of the item is negative then it's trapped/jammed;
			// leave it alone
			if (pObject->usItem != NOTHING && pObject->bStatus[bLoop] > 0)
			{
				bDamage = CheckItemForDamage( pObject->usItem, iDamage );
				switch( pObject->usItem )
				{
					case JAR_CREATURE_BLOOD:
					case JAR:
					case JAR_HUMAN_BLOOD:
					case JAR_ELIXIR:
						if ( PreRandom( bDamage ) > 5 )
						{
							// smash!
							bDamage = pObject->bStatus[ bLoop ];
						}
						break;
					default:
						break;
				}
				if ( Item[ pObject->usItem ].usItemClass == IC_AMMO  )
				{
					if ( PreRandom( 100 ) < (UINT32) bDamage )
					{
						// destroy clip completely
						pObject->bStatus[ bLoop ] = 1;
					}
				}
				else
				{
					pObject->bStatus[bLoop] -= bDamage;
					if (pObject->bStatus[bLoop] < 1)
					{
						pObject->bStatus[bLoop] = 1;
					}
				}
				// I don't think we increase viewrange based on items any more
				// FUN STUFF!  Check for explosives going off as a result!
				if (Item[pObject->usItem].usItemClass & IC_EXPLOSV)
				{
					if (CheckForChainReaction( pObject->usItem, pObject->bStatus[bLoop], bDamage, fOnGround ))
					{
						return( TRUE );
					}
				}

				// remove item from index AFTER checking explosions because need item data for explosion!
				if ( pObject->bStatus[bLoop] == 1 )
				{
					if ( pObject->ubNumberOfObjects > 1 )
					{
						RemoveObjFrom( pObject, bLoop );
						// since an item was just removed, the items above the current were all shifted down one;
						// to process them properly, we have to back up 1 in the counter
						bLoop = bLoop - 1;
					}
				}
			}
		}

		for (bLoop = 0; bLoop < MAX_ATTACHMENTS; bLoop++)
		{
			if (pObject->usAttachItem[bLoop] != NOTHING && pObject->bAttachStatus[bLoop] > 0)
			{
				pObject->bAttachStatus[bLoop] -= CheckItemForDamage( pObject->usAttachItem[bLoop], iDamage );
				if (pObject->bAttachStatus[bLoop] < 1)
				{
					pObject->bAttachStatus[bLoop] = 1;
				}
			}
		}
	}

	return( FALSE );
}

void CheckEquipmentForDamage( SOLDIERTYPE *pSoldier, INT32 iDamage )
{
	INT8				bSlot;
	BOOLEAN			fBlowsUp;
	UINT8				ubNumberOfObjects;

	if ( TANK( pSoldier ) )
	{
		return;
	}

	for (bSlot = 0; bSlot < NUM_INV_SLOTS; bSlot++)
	{
		ubNumberOfObjects = pSoldier->inv[bSlot].ubNumberOfObjects;
		fBlowsUp = DamageItem( &(pSoldier->inv[bSlot]), iDamage, FALSE );
		if (fBlowsUp)
		{
			// blow it up!
			if ( gTacticalStatus.ubAttackBusyCount )
			{
				IgniteExplosion( pSoldier->ubAttackerID, CenterX( pSoldier->sGridNo ), CenterY( pSoldier->sGridNo ), 0, pSoldier->sGridNo, pSoldier->inv[ bSlot ].usItem, pSoldier->bLevel );
			}
			else
			{
				IgniteExplosion( pSoldier->ubID, CenterX( pSoldier->sGridNo ), CenterY( pSoldier->sGridNo ), 0, pSoldier->sGridNo, pSoldier->inv[ bSlot ].usItem, pSoldier->bLevel );
			}

			// Remove item!
			DeleteObj( &(pSoldier->inv[ bSlot ]) );

			DirtyMercPanelInterface( pSoldier, DIRTYLEVEL2 );
		}
		else if ( ubNumberOfObjects != pSoldier->inv[bSlot].ubNumberOfObjects )
		{
			DirtyMercPanelInterface( pSoldier, DIRTYLEVEL2 );
		}
	}
}

void CheckEquipmentForFragileItemDamage( SOLDIERTYPE *pSoldier, INT32 iDamage )
{
	// glass jars etc can be damaged by falling over
	INT8				bSlot;
	UINT8				ubNumberOfObjects;
	BOOLEAN			fPlayedGlassBreak = FALSE;

	for (bSlot = 0; bSlot < NUM_INV_SLOTS; bSlot++)
	{
		switch( pSoldier->inv[bSlot].usItem )
		{
			case JAR_CREATURE_BLOOD:
			case JAR:
			case JAR_HUMAN_BLOOD:
			case JAR_ELIXIR:
				ubNumberOfObjects = pSoldier->inv[bSlot].ubNumberOfObjects;
				DamageItem( &(pSoldier->inv[bSlot]), iDamage, FALSE );
				if ( !fPlayedGlassBreak && (ubNumberOfObjects != pSoldier->inv[bSlot].ubNumberOfObjects) )
				{
					PlayJA2Sample( GLASS_CRACK, RATE_11025, SoundVolume( MIDVOLUME, pSoldier->sGridNo ), 1, SoundDir( pSoldier->sGridNo ) );
					fPlayedGlassBreak = TRUE;
					// only dirty once
					DirtyMercPanelInterface( pSoldier, DIRTYLEVEL2 );
				}
				break;
			default:
				break;
		}
	}
}


BOOLEAN DamageItemOnGround( OBJECTTYPE * pObject, INT16 sGridNo, INT8 bLevel, INT32 iDamage, UINT8 ubOwner )
{
	BOOLEAN			fBlowsUp;

	fBlowsUp = DamageItem( pObject, iDamage, TRUE );
	if ( fBlowsUp )
	{
		// OK, Ignite this explosion!
		IgniteExplosion( ubOwner, CenterX( sGridNo ), CenterY( sGridNo ), 0, sGridNo, pObject->usItem, bLevel );

		// Remove item!
		return( TRUE );
	}
	else if ( (pObject->ubNumberOfObjects < 2) && (pObject->bStatus[0] < USABLE) )
	{
		return( TRUE );
	}
	else
	{
		return( FALSE );
	}
}

// is the item a medical kit/first aid kit item?
INT8 IsMedicalKitItem( OBJECTTYPE *pObject )
{
	// check item id against current medical kits
	switch( pObject->usItem )
	{
		case( MEDICKIT ):
			// medical bag, return 1
			return ( 1 );
		break;
	}

	return( 0 );
}

void SwapHandItems( SOLDIERTYPE * pSoldier )
{
	BOOLEAN		fOk;

	CHECKV( pSoldier );
//<SB> cant swap very big item
	if(Item[pSoldier->inv[HANDPOS].usItem].fFlags & ITEM_IS_VERY_BIG)
		return;
//</SB>
	if (pSoldier->inv[HANDPOS].usItem == NOTHING || pSoldier->inv[SECONDHANDPOS].usItem == NOTHING)
	{
		// whatever is in the second hand can be swapped to the main hand!
		SwapObjs( &(pSoldier->inv[HANDPOS]), &(pSoldier->inv[SECONDHANDPOS]) );
		DirtyMercPanelInterface( pSoldier, DIRTYLEVEL2 );
	}
	else
	{
		if (TwoHandedItem( pSoldier->inv[SECONDHANDPOS].usItem ) )
		{
			// must move the item in the main hand elsewhere in the inventory
			fOk = InternalAutoPlaceObject( pSoldier, &(pSoldier->inv[HANDPOS]), FALSE, HANDPOS );
			if (!fOk)
			{
				return;
			}
			// the main hand is now empty so a swap is going to work...
		}
		SwapObjs( &(pSoldier->inv[HANDPOS]), &(pSoldier->inv[SECONDHANDPOS]) );
		DirtyMercPanelInterface( pSoldier, DIRTYLEVEL2 );
	}
}

void SwapOutHandItem( SOLDIERTYPE * pSoldier )
{
	BOOLEAN			fOk;

	CHECKV( pSoldier );

	// puts away the item in the main hand
	if (pSoldier->inv[HANDPOS].usItem != NOTHING )
	{
		if (pSoldier->inv[SECONDHANDPOS].usItem == NOTHING)
		{
			// just swap the hand item to the second hand
			SwapObjs( &(pSoldier->inv[HANDPOS]), &(pSoldier->inv[SECONDHANDPOS]) );
			DirtyMercPanelInterface( pSoldier, DIRTYLEVEL2 );
			return;
		}
		else
		{
			// try placing it somewhere else in our inventory
			fOk = AutoPlaceObject( pSoldier, &(pSoldier->inv[HANDPOS]), FALSE );
			if (fOk)
			{
				DirtyMercPanelInterface( pSoldier, DIRTYLEVEL2 );
			}
			// otherwise there's no room for the item anywhere!
		}
	}	
}

void WaterDamage( SOLDIERTYPE *pSoldier )
{
	// damage guy's equipment and camouflage due to water
	INT8		bLoop, bDamage, bDieSize;
	UINT32	uiRoll;

	if ( pSoldier->bOverTerrainType == DEEP_WATER )
	{
		for ( bLoop = 0; bLoop < NUM_INV_SLOTS; bLoop++ )
		{
			// if there's an item here that can get water damaged...
			if (pSoldier->inv[ bLoop ].usItem && Item[pSoldier->inv[ bLoop ].usItem].fFlags & ITEM_WATER_DAMAGES)
			{
				// roll the 'ol 100-sided dice
				uiRoll = PreRandom(100);

				// 10% chance of getting damage!
				if (uiRoll < 10)
				{
					// lose between 1 and 10 status points each time
					bDamage = (INT8) (10 - uiRoll);

					// but don't let anything drop lower than 1%
					pSoldier->inv[bLoop].bStatus[0] -= bDamage;
					if (pSoldier->inv[bLoop].bStatus[0] < 1)
					{
						pSoldier->inv[bLoop].bStatus[0] = 1;
					}
				}
			}
		}
	}
	if (pSoldier->bCamo > 0 && !HAS_SKILL_TRAIT( pSoldier, CAMOUFLAGED ) )
	{
		// reduce camouflage by 2% per tile of deep water
		// and 1% for medium water
		if ( pSoldier->bOverTerrainType == DEEP_WATER )
		{
			pSoldier->bCamo = __max( 0, pSoldier->bCamo - 2 );
		}
		else
		{
			pSoldier->bCamo = __max( 0, pSoldier->bCamo - 1 );
		}
		if (pSoldier->bCamo == 0)
		{
			// Reload palettes....
			if ( pSoldier->bInSector )
			{	
				CreateSoldierPalettes( pSoldier );
			}
			ScreenMsg( FONT_MCOLOR_LTYELLOW, MSG_INTERFACE, Message[STR_CAMMO_WASHED_OFF], pSoldier->name );
		}

	}
	if ( pSoldier->bTeam == gbPlayerNum && pSoldier->bMonsterSmell > 0 )
	{
		if ( pSoldier->bOverTerrainType == DEEP_WATER )
		{
			bDieSize = 10;
		}
		else
		{
			bDieSize = 20;
		}
		if ( Random( bDieSize ) == 0 )
		{
			pSoldier->bMonsterSmell--;
		}		
	}

	DirtyMercPanelInterface( pSoldier, DIRTYLEVEL2 );
}

BOOLEAN ApplyCammo( SOLDIERTYPE * pSoldier, OBJECTTYPE * pObj, BOOLEAN *pfGoodAPs )
{
	INT8		bPointsToUse;
	UINT16	usTotalKitPoints;

  (*pfGoodAPs) = TRUE;

	if (pObj->usItem != CAMOUFLAGEKIT)
	{
		return( FALSE );
	}

	if (!EnoughPoints( pSoldier, AP_CAMOFLAGE, 0, TRUE ) )
	{
    (*pfGoodAPs) = FALSE;
		return( TRUE );
	}

	usTotalKitPoints = TotalPoints( pObj );
	if (usTotalKitPoints == 0)
	{
		// HUH??? 
		return( FALSE );
	}

	if (pSoldier->bCamo == 100)
	{
		// nothing more to add
		return( FALSE );
	}

	// points are used up at a rate of 50% kit = 100% cammo on guy
	// add 1 to round off
	bPointsToUse = (100 - pSoldier->bCamo + 1 ) / 2;
	bPointsToUse = __min( bPointsToUse, usTotalKitPoints );
	pSoldier->bCamo = __min( 100, pSoldier->bCamo + bPointsToUse * 2);
	
	UseKitPoints( pObj, bPointsToUse, pSoldier );

	DeductPoints( pSoldier, AP_CAMOFLAGE, 0 );

	// Reload palettes....
	if ( pSoldier->bInSector )
	{	
		CreateSoldierPalettes( pSoldier );
	}

	return( TRUE );
}

BOOLEAN ApplyCanteen( SOLDIERTYPE * pSoldier, OBJECTTYPE * pObj, BOOLEAN *pfGoodAPs )
{
	INT16		sPointsToUse;
	UINT16	usTotalKitPoints;

  (*pfGoodAPs) = TRUE;

	if (pObj->usItem != CANTEEN)
	{
		return( FALSE );
	}

	usTotalKitPoints = TotalPoints( pObj );
	if (usTotalKitPoints == 0)
	{
		// HUH??? 
		return( FALSE );
	}

	if (!EnoughPoints( pSoldier, AP_DRINK, 0, TRUE ) )
	{
    (*pfGoodAPs) = FALSE;
		return( TRUE );
	}

  if ( pSoldier->bTeam == gbPlayerNum )
  {
    if ( gMercProfiles[ pSoldier->ubProfile ].bSex == MALE )
    {
		  PlayJA2Sample( DRINK_CANTEEN_MALE, RATE_11025, MIDVOLUME, 1, MIDDLEPAN );
    }
    else
    {
		  PlayJA2Sample( DRINK_CANTEEN_FEMALE, RATE_11025, MIDVOLUME, 1, MIDDLEPAN );
    }
  }

	sPointsToUse = __min( 20, usTotalKitPoints );

	// CJC Feb 9.  Canteens don't seem effective enough, so doubled return from them
	DeductPoints( pSoldier, AP_DRINK, (INT16) (2 * sPointsToUse * -(100 - pSoldier->bBreath) ) );

	UseKitPoints( pObj, sPointsToUse, pSoldier );

	return( TRUE );
}

BOOLEAN ApplyBloodyKnife( SOLDIERTYPE * pSoldier, OBJECTTYPE * pObj, BOOLEAN *pfGoodAPs )
{
	INT16		sPointsToUse;
	UINT16	usTotalKitPoints;

	(*pfGoodAPs) = TRUE;

	if (pObj->usItem != BLOODY_THROWING_KNIFE)
	{
		return( FALSE );
	}

	pObj->usItem = THROWING_KNIFE;
	return( TRUE );
}

#define MAX_HUMAN_CREATURE_SMELL (NORMAL_HUMAN_SMELL_STRENGTH - 1)

BOOLEAN ApplyElixir( SOLDIERTYPE * pSoldier, OBJECTTYPE * pObj, BOOLEAN *pfGoodAPs )
{
	INT16		sPointsToUse;
	UINT16	usTotalKitPoints;

  (*pfGoodAPs) = TRUE;

	if (pObj->usItem != JAR_ELIXIR )
	{
		return( FALSE );
	}

	usTotalKitPoints = TotalPoints( pObj );
	if (usTotalKitPoints == 0)
	{
		// HUH??? 
		return( FALSE );
	}

	if (!EnoughPoints( pSoldier, AP_CAMOFLAGE, 0, TRUE ) )
	{
    (*pfGoodAPs) = FALSE;
		return( TRUE );
	}

	DeductPoints( pSoldier, AP_CAMOFLAGE, 0 );

	sPointsToUse = ( MAX_HUMAN_CREATURE_SMELL - pSoldier->bMonsterSmell ) * 2;
	sPointsToUse = __min( sPointsToUse, usTotalKitPoints );

	UseKitPoints( pObj, sPointsToUse, pSoldier );

	pSoldier->bMonsterSmell += sPointsToUse / 2;

	return( TRUE );
}

UINT32 ConvertProfileMoneyValueToObjectTypeMoneyValue( UINT8 ubStatus )
{
	return( ubStatus * 50 );
}

UINT8 ConvertObjectTypeMoneyValueToProfileMoneyValue( UINT32 uiMoneyAmount )
{
	return( (UINT8)( uiMoneyAmount / 50 ) );
}

BOOLEAN ItemIsCool( OBJECTTYPE * pObj )
{
	if (pObj->bStatus[0] < 60)
	{
		return( FALSE );
	}
	if ( Item[ pObj->usItem ].usItemClass & IC_WEAPON )
	{
		if ( Weapon[ Item[ pObj->usItem].ubClassIndex ].ubDeadliness >= 30 )
		{
			return( TRUE );
		}
	}
	else if ( Item[ pObj->usItem ].usItemClass & IC_ARMOUR )
	{
		if ( Armour[ Item[ pObj->usItem ].ubClassIndex ].ubProtection >= 20 )
		{
			return( TRUE );
		}
	}

	return( FALSE );
}

void ActivateXRayDevice( SOLDIERTYPE * pSoldier )
{
	SOLDIERTYPE *	pSoldier2;
	UINT32				uiSlot;
	INT8					bBatteries;

	// check for batteries
	bBatteries = FindAttachment( &(pSoldier->inv[HANDPOS]), BATTERIES );
	if ( bBatteries == NO_SLOT )
	{
		// doesn't work without batteries!
		return;
	}

	// use up 8-12 percent of batteries
	pSoldier->inv[ HANDPOS ].bAttachStatus[ bBatteries ] -= (INT8) (8 + Random( 5 ));
	if ( pSoldier->inv[ HANDPOS ].bAttachStatus[ bBatteries ] <= 0 )
	{
		// destroy batteries
		pSoldier->inv[ HANDPOS ].usAttachItem[ bBatteries ] = NOTHING;
		pSoldier->inv[ HANDPOS ].bAttachStatus[ bBatteries ] = 0;
	}

	// first, scan through all mercs and turn off xrayed flag for anyone
	// previously xrayed by this guy
	for ( uiSlot = 0; uiSlot < guiNumMercSlots; uiSlot++ )
	{
		pSoldier2 = MercSlots[ uiSlot ];
		if ( pSoldier2 )
		{
			if ( (pSoldier2->ubMiscSoldierFlags & SOLDIER_MISC_XRAYED) && (pSoldier2->ubXRayedBy == pSoldier->ubID) )
			{
				pSoldier2->ubMiscSoldierFlags &= (~SOLDIER_MISC_XRAYED);
				pSoldier2->ubXRayedBy = NOBODY;
			}
		}
	}
	// now turn on xray for anyone within range
	for ( uiSlot = 0; uiSlot < guiNumMercSlots; uiSlot++ )
	{
		pSoldier2 = MercSlots[ uiSlot ];
		if ( pSoldier2 )
		{
			if ( pSoldier2->bTeam != pSoldier->bTeam && PythSpacesAway( pSoldier->sGridNo, pSoldier2->sGridNo ) < XRAY_RANGE )
			{
				pSoldier2->ubMiscSoldierFlags |= SOLDIER_MISC_XRAYED;
				pSoldier2->ubXRayedBy = pSoldier->ubID;
			}
		}
	}
	pSoldier->uiXRayActivatedTime = GetWorldTotalSeconds();
}

void TurnOffXRayEffects( SOLDIERTYPE * pSoldier )
{
	SOLDIERTYPE *	pSoldier2;
	UINT32				uiSlot;

	if ( !pSoldier->uiXRayActivatedTime )
	{
		return;
	}

	// scan through all mercs and turn off xrayed flag for anyone
	// xrayed by this guy
	for ( uiSlot = 0; uiSlot < guiNumMercSlots; uiSlot++ )
	{
		pSoldier2 = MercSlots[ uiSlot ];
		if ( pSoldier2 )
		{
			if ( (pSoldier2->ubMiscSoldierFlags & SOLDIER_MISC_XRAYED) && (pSoldier2->ubXRayedBy == pSoldier->ubID) )
			{
				pSoldier2->ubMiscSoldierFlags &= (~SOLDIER_MISC_XRAYED);
				pSoldier2->ubXRayedBy = NOBODY;
			}
		}
	}
	pSoldier->uiXRayActivatedTime = 0;
}



#ifdef JA2TESTVERSION
void DumpItemsList( void )
{
  CHAR8 zPrintFileName[60];
  FILE *FDump;
	UINT16 usItem;
	INVTYPE *pItem;

  // open output file
 	strcpy(zPrintFileName, "ItemDump.txt");
  FDump = fopen(zPrintFileName, "wt");

  if (FDump == NULL)
    return;

	// print headings
	fprintf(FDump, "            ITEM              COOLNESS  VALUE\n");
	fprintf(FDump, "============================  ========  =====\n");

	for( usItem = 0; usItem < MAXITEMS; usItem++ )
	{
		pItem= &( Item[ usItem ] );
	
		if (pItem->ubCoolness > 0 )
		{
			fprintf(FDump, "%28ls     %2d     $%4d\n", ItemNames[ usItem ], pItem->ubCoolness, pItem->usPrice );
		}
	}

  fclose(FDump);
}
#endif // JA2TESTVERSION
